"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInsightQuery = void 0;
var _react = require("react");
var _common = require("@kbn/data-plugin/common");
var _timeline = require("../../../../../../common/types/timeline");
var _kibana = require("../../../../lib/kibana");
var _kuery = require("../../../../lib/kuery");
var _containers = require("../../../../../timelines/containers");
var _sourcerer = require("../../../../containers/sourcerer");
var _model = require("../../../../store/sourcerer/model");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInsightQuery = ({
  dataProviders,
  filters,
  relativeTimerange
}) => {
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const esQueryConfig = (0, _react.useMemo)(() => (0, _common.getEsQueryConfig)(uiSettings), [uiSettings]);
  const {
    browserFields,
    selectedPatterns,
    indexPattern,
    dataViewId
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const [hasError, setHasError] = (0, _react.useState)(false);
  const combinedQueries = (0, _react.useMemo)(() => {
    try {
      if (hasError === false) {
        const parsedCombinedQueries = (0, _kuery.combineQueries)({
          config: esQueryConfig,
          dataProviders,
          indexPattern,
          browserFields,
          filters,
          kqlQuery: {
            query: '',
            language: 'kuery'
          },
          kqlMode: 'filter'
        });
        return parsedCombinedQueries;
      }
    } catch (err) {
      setHasError(true);
      return null;
    }
  }, [browserFields, dataProviders, esQueryConfig, hasError, indexPattern, filters]);
  const [isQueryLoading, {
    events,
    totalCount
  }] = (0, _containers.useTimelineEvents)({
    dataViewId,
    fields: ['*'],
    filterQuery: combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery,
    id: _timeline.TimelineId.active,
    indexNames: selectedPatterns,
    language: 'kuery',
    limit: 1,
    runtimeMappings: {},
    ...(relativeTimerange ? {
      startDate: relativeTimerange === null || relativeTimerange === void 0 ? void 0 : relativeTimerange.from,
      endDate: relativeTimerange === null || relativeTimerange === void 0 ? void 0 : relativeTimerange.to
    } : {})
  });
  const [oldestEvent] = events;
  const timestamp = oldestEvent && oldestEvent.data && oldestEvent.data.find(d => d.field === '@timestamp');
  const oldestTimestamp = timestamp && timestamp.value && timestamp.value[0];
  return {
    isQueryLoading,
    totalCount,
    oldestTimestamp,
    hasError
  };
};
exports.useInsightQuery = useInsightQuery;