"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTopNPopOver = exports.getAdditionalScreenReaderOnlyContext = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAdditionalScreenReaderOnlyContext = ({
  field,
  value
}) => {
  if (value == null) {
    return field;
  }
  return Array.isArray(value) ? `${field} ${value.join(' ')}` : `${field} ${value}`;
};
exports.getAdditionalScreenReaderOnlyContext = getAdditionalScreenReaderOnlyContext;
const useTopNPopOver = setIsPopoverVisible => {
  const [isShowingTopN, setShowTopN] = (0, _react.useState)(false);
  const toggleTopN = (0, _react.useCallback)(() => {
    setShowTopN(prevShowTopN => {
      const newShowTopN = !prevShowTopN;
      if (setIsPopoverVisible) setIsPopoverVisible(newShowTopN);
      return newShowTopN;
    });
  }, [setIsPopoverVisible]);
  const closeTopN = (0, _react.useCallback)(() => {
    setShowTopN(false);
  }, []);
  return {
    closeTopN,
    toggleTopN,
    isShowingTopN
  };
};
exports.useTopNPopOver = useTopNPopOver;