"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHeaderAlignment = exports.HeaderSection = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _classnames = _interopRequireDefault(require("classnames"));
var _inspect = require("../inspect");
var _subtitle = require("../subtitle");
var i18n = _interopRequireWildcard(require("../../containers/query_toggle/translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Header = _styledComponents.default.header`
  &.toggle-expand {
    margin-bottom: ${({
  theme
}) => theme.eui.euiSizeL};
  }

  .no-margin {
    margin-top: 0 !important;
    margin-bottom: 0 !important;
  }

  ${({
  height
}) => height && (0, _styledComponents.css)`
      height: ${height}px;
    `}
  margin-bottom: 0;
  user-select: text;

  ${({
  border
}) => border && (0, _styledComponents.css)`
      border-bottom: ${({
  theme
}) => theme.eui.euiBorderThin};
      padding-bottom: ${({
  theme
}) => theme.eui.euiSizeL};
    `}
`;
Header.displayName = 'Header';
const getHeaderAlignment = ({
  alignHeader,
  stackHeader
}) => {
  if (alignHeader != null) {
    return alignHeader;
  } else if (stackHeader) {
    return undefined;
  } else {
    return 'center';
  }
};
exports.getHeaderAlignment = getHeaderAlignment;
const HeaderSectionComponent = ({
  alignHeader,
  border,
  children,
  outerDirection = 'column',
  growLeftSplit = true,
  headerFilters,
  height,
  hideSubtitle = false,
  id,
  inspectMultiple = false,
  inspectTitle,
  isInspectDisabled,
  showInspectButton = true,
  split,
  stackHeader,
  subtitle,
  title,
  titleSize = 'l',
  toggleQuery,
  toggleStatus = true,
  tooltip,
  tooltipTitle
}) => {
  const toggle = (0, _react.useCallback)(() => {
    if (toggleQuery) {
      toggleQuery(!toggleStatus);
    }
  }, [toggleQuery, toggleStatus]);
  const classNames = (0, _classnames.default)({
    'toggle-expand': toggleStatus,
    siemHeaderSection: true
  });
  return /*#__PURE__*/_react.default.createElement(Header, {
    "data-test-subj": "header-section",
    border: border,
    height: height,
    className: classNames,
    $hideSubtitle: hideSubtitle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "headerSectionOuterFlexGroup",
    direction: outerDirection,
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: growLeftSplit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: getHeaderAlignment({
      alignHeader,
      stackHeader
    }),
    "data-test-subj": "headerSectionInnerFlexGroup",
    direction: stackHeader ? 'column' : 'row',
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: growLeftSplit,
    className: toggleStatus ? '' : 'no-margin'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: 'none',
    className: "header-section-titles"
  }, toggleQuery && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "query-toggle-header",
    "aria-label": i18n.QUERY_BUTTON_TITLE(toggleStatus),
    color: "text",
    display: "empty",
    iconType: toggleStatus ? 'arrowDown' : 'arrowRight',
    onClick: toggle,
    size: "s",
    title: i18n.QUERY_BUTTON_TITLE(toggleStatus)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: titleSize
  }, /*#__PURE__*/_react.default.createElement("h4", {
    "data-test-subj": "header-section-title"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textBreakNormal"
  }, title), tooltip && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    color: "subdued",
    title: tooltipTitle,
    content: tooltip,
    size: "l",
    type: "iInCircle"
  }))))))), id && toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    isDisabled: isInspectDisabled,
    queryId: id,
    multiple: inspectMultiple,
    showInspectButton: showInspectButton,
    title: inspectTitle !== null && inspectTitle !== void 0 ? inspectTitle : title
  })), headerFilters && toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "header-section-filters",
    grow: false
  }, headerFilters))), children && toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "header-section-supplements",
    grow: split ? true : false
  }, children))), !hideSubtitle && toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_subtitle.Subtitle, {
    "data-test-subj": "header-section-subtitle",
    items: subtitle
  }))));
};
const HeaderSection = /*#__PURE__*/_react.default.memo(HeaderSectionComponent);
exports.HeaderSection = HeaderSection;