"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterByAssigneesPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("./constants");
var _assignees_popover = require("../assignees/assignees_popover");
var _use_license = require("../../hooks/use_license");
var _use_upselling = require("../../hooks/use_upselling");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The popover to filter alerts by assigned users
 */
const FilterByAssigneesPopover = /*#__PURE__*/(0, _react.memo)(({
  assignedUserIds,
  onSelectionChange
}) => {
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const upsellingMessage = (0, _use_upselling.useUpsellingMessage)('alert_assignments');
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(value => !value), []);
  const [selectedAssignees, setSelectedAssignees] = (0, _react.useState)(assignedUserIds);
  const handleSelectionChange = (0, _react.useCallback)(users => {
    setSelectedAssignees(users);
    onSelectionChange === null || onSelectionChange === void 0 ? void 0 : onSelectionChange(users);
  }, [onSelectionChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_assignees_popover.AssigneesPopover, {
    assignedUserIds: assignedUserIds,
    showUnassignedOption: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: upsellingMessage !== null && upsellingMessage !== void 0 ? upsellingMessage : _i18n.i18n.translate('xpack.securitySolution.filtersGroup.assignees.popoverTooltip', {
        defaultMessage: 'Filter by assignee'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": _constants.TEST_IDS.FILTER_BY_ASSIGNEES_BUTTON,
      iconType: "arrowDown",
      badgeColor: "subdued",
      disabled: !isPlatinumPlus,
      onClick: togglePopover,
      isSelected: isPopoverOpen,
      hasActiveFilters: selectedAssignees.length > 0,
      numActiveFilters: selectedAssignees.length
    }, _i18n.i18n.translate('xpack.securitySolution.filtersGroup.assignees.buttonTitle', {
      defaultMessage: 'Assignees'
    }))),
    isPopoverOpen: isPopoverOpen,
    closePopover: togglePopover,
    onSelectionChange: handleSelectionChange
  }));
});
exports.FilterByAssigneesPopover = FilterByAssigneesPopover;
FilterByAssigneesPopover.displayName = 'FilterByAssigneesPopover';