"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldSelection = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _components = require("../../../detections/components/alerts_kpis/common/components");
var _translations = require("../../../detections/components/alerts_kpis/common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartOptionsFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const FieldSelectionComponent = ({
  chartOptionsContextMenu,
  setStackByField0,
  setStackByField0ComboboxInputRef,
  setStackByField1,
  setStackByField1ComboboxInputRef,
  stackByField0,
  stackByField0ComboboxRef,
  stackByField1,
  stackByField1ComboboxRef,
  stackByWidth,
  uniqueQueryId,
  useLensCompatibleFields
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "flexStart",
  "data-test-subj": "fieldSelection",
  gutterSize: "none"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_components.StackByComboBox, {
  "aria-label": _translations.GROUP_BY_LABEL,
  ref: stackByField0ComboboxRef,
  "data-test-subj": "groupBy",
  onSelect: setStackByField0,
  prepend: _translations.GROUP_BY_LABEL,
  selected: stackByField0,
  inputRef: setStackByField0ComboboxInputRef,
  width: stackByWidth,
  useLensCompatibleFields: useLensCompatibleFields
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_components.StackByComboBox, {
  "aria-label": _translations.GROUP_BY_TOP_LABEL,
  ref: stackByField1ComboboxRef,
  "data-test-subj": "groupByTop",
  onSelect: setStackByField1,
  prepend: _translations.GROUP_BY_TOP_LABEL,
  selected: stackByField1 !== null && stackByField1 !== void 0 ? stackByField1 : '',
  inputRef: setStackByField1ComboboxInputRef,
  width: stackByWidth,
  useLensCompatibleFields: useLensCompatibleFields
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, chartOptionsContextMenu != null && /*#__PURE__*/_react.default.createElement(ChartOptionsFlexItem, {
  grow: false
}, chartOptionsContextMenu(uniqueQueryId))));
FieldSelectionComponent.displayName = 'FieldSelectionComponent';
const FieldSelection = /*#__PURE__*/_react.default.memo(FieldSelectionComponent);
exports.FieldSelection = FieldSelection;