"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdatedFlexItem = exports.UpdatedFlexGroup = exports.StyledEuiPanel = exports.ScrollableFlexItem = exports.SELECTOR_TIMELINE_GLOBAL_CONTAINER = exports.FullWidthFlexGroupTable = exports.FullWidthFlexGroup = exports.FullScreenContainer = exports.EventsContainerLoading = exports.EVENTS_TABLE_CLASS_NAME = void 0;
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SELECTOR_TIMELINE_GLOBAL_CONTAINER = 'securitySolutionTimeline__container';
exports.SELECTOR_TIMELINE_GLOBAL_CONTAINER = SELECTOR_TIMELINE_GLOBAL_CONTAINER;
const EVENTS_TABLE_CLASS_NAME = 'siemEventsTable';
exports.EVENTS_TABLE_CLASS_NAME = EVENTS_TABLE_CLASS_NAME;
const FullScreenContainer = _styledComponents.default.div`
  height: ${({
  $isFullScreen
}) => $isFullScreen ? '100%' : undefined};
  flex: 1 1 auto;
  display: flex;
  width: 100%;
`;
exports.FullScreenContainer = FullScreenContainer;
const FullWidthFlexGroupTable = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  overflow: hidden;
  margin: 0;
  display: ${({
  $visible
}) => $visible ? 'flex' : 'none'};
`;
exports.FullWidthFlexGroupTable = FullWidthFlexGroupTable;
const ScrollableFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  overflow: auto;
`;
exports.ScrollableFlexItem = ScrollableFlexItem;
const FullWidthFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  overflow: hidden;
  margin: 0;
  min-height: 490px;
  display: ${({
  $visible = true
}) => $visible ? 'flex' : 'none'};
`;
exports.FullWidthFlexGroup = FullWidthFlexGroup;
const UpdatedFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  ${({
  $hasRightOffset,
  theme,
  position
}) => position === 'relative' ? `margin-right: ${theme.eui.euiSizeXS}; margin-left: ` : $hasRightOffset && position === 'absolute' ? `margin-right: ${theme.eui.euiSizeXL};` : `margin-right: ${theme.eui.euiSizeXS};`}
  ${({
  position
}) => {
  return position === 'absolute' ? `position: absolute` : `display: flex; justify-content:center; align-items:center`;
}};
  display: inline-flex;
  z-index: ${({
  theme
}) => theme.eui.euiZLevel1 - 3};
  ${({
  $hasRightOffset,
  theme,
  position
}) => position === 'relative' ? `right: 0;` : $hasRightOffset && position === 'absolute' ? `right: ${theme.eui.euiSizeXL};` : `right: ${theme.eui.euiSizeL};`}
`;
exports.UpdatedFlexGroup = UpdatedFlexGroup;
const UpdatedFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  ${({
  $show
}) => $show ? '' : 'visibility: hidden;'}
`;
exports.UpdatedFlexItem = UpdatedFlexItem;
const EventsContainerLoading = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `${SELECTOR_TIMELINE_GLOBAL_CONTAINER} ${className}`
}))`
  position: relative;
  width: 100%;
  overflow: hidden;
  flex: 1;
  display: flex;
  flex-direction: column;
`;
exports.EventsContainerLoading = EventsContainerLoading;
const StyledEuiPanel = (0, _styledComponents.default)(_eui.EuiPanel)`
  display: flex;
  flex-direction: column;
  position: relative;
  width: 100%;

  ${({
  $isFullScreen
}) => $isFullScreen && `
    border: 0;
    box-shadow: none;
    padding-top: 0;
    padding-bottom: 0;
`}
`;
exports.StyledEuiPanel = StyledEuiPanel;