"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewCardWithActions = exports.OverviewCard = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _cell_actions = require("../../cell_actions");
var _helpers = require("../../../../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionWrapper = _common.euiStyled.div`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const OverviewPanel = (0, _common.euiStyled)(_eui.EuiPanel)`
  &&& {
    background-color: ${({
  theme
}) => theme.eui.euiColorLightestShade};
    padding: ${({
  theme
}) => theme.eui.euiSizeS};
    height: 78px;
  }

  &:hover {
    .inlineActions {
      opacity: 1;
      width: auto;
      transform: translate(0);
    }
  }

  .inlineActions {
    opacity: 0;
    width: 0;
    transform: translate(6px);
    transition: transform 50ms ease-in-out;

    &.inlineActions-popoverOpen {
      opacity: 1;
      width: auto;
      transform: translate(0);
    }
   }
`;
const OverviewCard = ({
  title,
  children
}) => /*#__PURE__*/_react.default.createElement(OverviewPanel, {
  borderRadius: "none",
  hasShadow: false,
  hasBorder: false,
  paddingSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, title), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), children);
exports.OverviewCard = OverviewCard;
OverviewCard.displayName = 'OverviewCard';
const ClampedContent = _common.euiStyled.div`
  /* Clamp text content to 2 lines */
  display: -webkit-box;
  -webkit-line-clamp: 2;
  -webkit-box-orient: vertical;
  overflow: hidden;
`;
ClampedContent.displayName = 'ClampedContent';
const OverviewCardWithActions = ({
  title,
  children,
  contextId,
  dataTestSubj,
  enrichedFieldInfo
}) => /*#__PURE__*/_react.default.createElement(OverviewCard, {
  title: title
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "none"
}, /*#__PURE__*/_react.default.createElement(ClampedContent, {
  "data-test-subj": dataTestSubj
}, children), /*#__PURE__*/_react.default.createElement(ActionWrapper, null, /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
  data: {
    field: enrichedFieldInfo.data.field,
    value: enrichedFieldInfo === null || enrichedFieldInfo === void 0 ? void 0 : enrichedFieldInfo.values
  },
  triggerId: _cell_actions.SecurityCellActionsTrigger.DETAILS_FLYOUT,
  mode: _cell_actions.CellActionsMode.INLINE,
  sourcererScopeId: (0, _helpers.getSourcererScopeId)(contextId),
  metadata: {
    scopeId: contextId
  },
  visibleCellActions: 3
}))));
exports.OverviewCardWithActions = OverviewCardWithActions;
OverviewCardWithActions.displayName = 'OverviewCardWithActions';