"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InsightAccordion = void 0;
var _react = _interopRequireDefault(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledAccordion = (0, _common.euiStyled)(_eui.EuiAccordion)`
  border: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
  padding: 10px 8px;
  border-radius: 6px;
`;
/**
 * A special accordion that is used in the Insights section on the alert flyout.
 * It wraps logic and custom styling around the loading, error and success states of an insight section.
 */
const InsightAccordion = /*#__PURE__*/_react.default.memo(({
  prefix,
  state,
  text,
  renderContent,
  onToggle = _fp.noop,
  extraAction,
  forceState
}) => {
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix
  });
  switch (state) {
    case 'loading':
      // Don't render content when loading
      return /*#__PURE__*/_react.default.createElement(StyledAccordion, {
        id: accordionId,
        buttonContent: text,
        onToggle: onToggle,
        isLoading: true
      });
    case 'error':
      // Display an alert icon and don't render content when there was an error
      return /*#__PURE__*/_react.default.createElement(StyledAccordion, {
        id: accordionId,
        buttonContent: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "warning",
          color: "danger",
          style: {
            marginRight: '6px'
          }
        }), text),
        onToggle: onToggle,
        extraAction: extraAction
      });
    case 'success':
      // The accordion can display the content now
      return /*#__PURE__*/_react.default.createElement(StyledAccordion, {
        "tour-step": `${prefix}-accordion`,
        "data-test-subj": `${prefix}-accordion`,
        id: accordionId,
        buttonContent: text,
        onToggle: onToggle,
        paddingSize: "l",
        extraAction: extraAction,
        forceState: forceState
      }, renderContent());
    default:
      return null;
  }
});
exports.InsightAccordion = InsightAccordion;
InsightAccordion.displayName = 'InsightAccordion';