"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointIsolateForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _missing_encryption_key_callout = require("../../../../management/components/missing_encryption_key_callout");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointIsolateForm = /*#__PURE__*/(0, _react.memo)(({
  hostName,
  onCancel,
  onConfirm,
  onChange,
  comment = '',
  messageAppend,
  isLoading = false,
  hideCommentField = false
}) => {
  const handleCommentChange = (0, _react.useCallback)(event => {
    onChange({
      comment: event.target.value
    });
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_missing_encryption_key_callout.MissingEncryptionKeyCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "endpointHostIsolationForm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.hostIsolation.isolateThisHost",
    defaultMessage: "Isolate host {hostName} from network.",
    values: {
      hostName: /*#__PURE__*/_react.default.createElement("b", null, hostName)
    }
  }), /*#__PURE__*/_react.default.createElement("br", null)), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.hostIsolation.isolateThisHostAbout",
    defaultMessage: "Isolating a host will disconnect it from the network. The host will only be able to communicate with the Kibana platform."
  }), ' ', messageAppend))), !hideCommentField && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations.COMMENT,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    "data-test-subj": "host_isolation_comment",
    fullWidth: true,
    placeholder: _translations.COMMENT_PLACEHOLDER,
    value: comment,
    onChange: handleCommentChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    disabled: isLoading,
    "data-test-subj": "hostIsolateCancelButton"
  }, _translations.CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: onConfirm,
    disabled: isLoading,
    isLoading: isLoading,
    "data-test-subj": "hostIsolateConfirmButton"
  }, _translations.CONFIRM))))));
});
exports.EndpointIsolateForm = EndpointIsolateForm;
EndpointIsolateForm.displayName = 'EndpointIsolateForm';