"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CHECKBOX_FOR_ROW = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHECKBOX_FOR_ROW = ({
  ariaRowindex,
  columnValues,
  checked
}) => _i18n.i18n.translate('xpack.securitySolution.controlColumns.checkboxForRowAriaLabel', {
  values: {
    ariaRowindex,
    checked,
    columnValues
  },
  defaultMessage: '{checked, select, false {unchecked} true {checked}} checkbox for the alert or event in row {ariaRowindex}, with columns {columnValues}'
});
exports.CHECKBOX_FOR_ROW = CHECKBOX_FOR_ROW;