"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Legend = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _legend_item = require("./legend_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LegendComponent = ({
  legendItems
}) => {
  if (legendItems.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": "legend"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, legendItems.map((item, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `legend-item-${i}`,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_legend_item.LegendItem, {
    legendItem: item
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    "data-test-subj": "legend-spacer",
    size: "s"
  })))));
};
LegendComponent.displayName = 'LegendComponent';
const Legend = /*#__PURE__*/_react.default.memo(LegendComponent);
exports.Legend = Legend;