"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DraggableLegendItem = void 0;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _constants = require("../../../../common/constants");
var _draggables = require("../draggables");
var _kibana = require("../../lib/kibana");
var _translation = require("./translation");
var _validators = require("../../utils/validators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CountFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  ${({
  theme
}) => `margin-right: ${theme.eui.euiSizeS};`}
`;
/**
 * Renders the value or a placeholder in case the value is empty
 */
const ValueWrapper = /*#__PURE__*/_react.default.memo(({
  value
}) => (0, _validators.hasValueToDisplay)(value) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value) : /*#__PURE__*/_react.default.createElement("em", {
  "data-test-subj": "value-wrapper-empty"
}, _translation.EMPTY_VALUE_LABEL));
ValueWrapper.displayName = 'ValueWrapper';
const DraggableLegendItemComponent = ({
  legendItem
}) => {
  const [defaultNumberFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const {
    color,
    count,
    dataProviderId,
    field,
    scopeId,
    value
  } = legendItem;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, color != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    "data-test-subj": "legend-color",
    color: color
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
    "data-test-subj": `legend-item-${dataProviderId}`,
    field: field,
    hideTopN: true,
    id: dataProviderId,
    isDraggable: false,
    scopeId: scopeId,
    value: value
  }, legendItem.render == null ? /*#__PURE__*/_react.default.createElement(ValueWrapper, {
    value: value
  }) : legendItem.render({
    field,
    value
  }))), count != null && /*#__PURE__*/_react.default.createElement(CountFlexItem, {
    "data-test-subj": "legendItemCount",
    grow: false
  }, (0, _numeral.default)(count).format(defaultNumberFormat))))));
};
DraggableLegendItemComponent.displayName = 'DraggableLegendItemComponent';
const DraggableLegendItem = /*#__PURE__*/_react.default.memo(DraggableLegendItemComponent);
exports.DraggableLegendItem = DraggableLegendItem;