"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssigneesApplyPanel = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _userProfileComponents = require("@kbn/user-profile-components");
var _lodash = require("lodash");
var _use_get_current_user_profile = require("../user_profiles/use_get_current_user_profile");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("./constants");
var _use_suggest_users = require("../user_profiles/use_suggest_users");
var _use_bulk_get_user_profiles = require("../user_profiles/use_bulk_get_user_profiles");
var _utils = require("./utils");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The popover to allow selection of users from a list
 */
const AssigneesApplyPanel = /*#__PURE__*/(0, _react.memo)(({
  searchInputId,
  assignedUserIds,
  showUnassignedOption,
  onSelectionChange,
  onAssigneesApply
}) => {
  const {
    data: currentUserProfile
  } = (0, _use_get_current_user_profile.useGetCurrentUserProfile)();
  const existingIds = (0, _react.useMemo)(() => new Set((0, _utils.removeNoAssigneesSelection)(assignedUserIds)), [assignedUserIds]);
  const {
    isLoading: isLoadingAssignedUsers,
    data: assignedUsers
  } = (0, _use_bulk_get_user_profiles.useBulkGetUserProfiles)({
    uids: existingIds
  });
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const {
    isLoading: isLoadingSuggestedUsers,
    data: userProfiles
  } = (0, _use_suggest_users.useSuggestUsers)({
    searchTerm
  });
  const searchResultProfiles = (0, _react.useMemo)(() => {
    var _bringCurrentUserToFr;
    const sortedUsers = (_bringCurrentUserToFr = (0, _utils.bringCurrentUserToFrontAndSort)(currentUserProfile, userProfiles)) !== null && _bringCurrentUserToFr !== void 0 ? _bringCurrentUserToFr : [];
    if (showUnassignedOption && (0, _lodash.isEmpty)(searchTerm)) {
      return [_constants.NO_ASSIGNEES_VALUE, ...sortedUsers];
    }
    return sortedUsers;
  }, [currentUserProfile, searchTerm, showUnassignedOption, userProfiles]);
  const [selectedAssignees, setSelectedAssignees] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    if (isLoadingAssignedUsers || !assignedUsers) {
      return;
    }
    const hasNoAssigneesSelection = assignedUserIds.find(uid => uid === _constants.NO_ASSIGNEES_VALUE);
    const newAssignees = hasNoAssigneesSelection !== undefined ? [_constants.NO_ASSIGNEES_VALUE, ...assignedUsers] : assignedUsers;
    setSelectedAssignees(newAssignees);
  }, [assignedUserIds, assignedUsers, isLoadingAssignedUsers]);
  const handleSelectedAssignees = (0, _react.useCallback)(newAssignees => {
    if (!(0, _fp.isEqual)(newAssignees, selectedAssignees)) {
      setSelectedAssignees(newAssignees);
      onSelectionChange === null || onSelectionChange === void 0 ? void 0 : onSelectionChange(newAssignees.map(assignee => {
        var _assignee$uid;
        return (_assignee$uid = assignee === null || assignee === void 0 ? void 0 : assignee.uid) !== null && _assignee$uid !== void 0 ? _assignee$uid : _constants.NO_ASSIGNEES_VALUE;
      }));
    }
  }, [onSelectionChange, selectedAssignees]);
  const handleApplyButtonClick = (0, _react.useCallback)(() => {
    const selectedIds = selectedAssignees.map(assignee => {
      var _assignee$uid2;
      return (_assignee$uid2 = assignee === null || assignee === void 0 ? void 0 : assignee.uid) !== null && _assignee$uid2 !== void 0 ? _assignee$uid2 : _constants.NO_ASSIGNEES_VALUE;
    });
    onAssigneesApply === null || onAssigneesApply === void 0 ? void 0 : onAssigneesApply(selectedIds);
  }, [onAssigneesApply, selectedAssignees]);
  const selectedStatusMessage = (0, _react.useCallback)(total => i18n.ASSIGNEES_SELECTION_STATUS_MESSAGE(total), []);
  const isLoading = isLoadingAssignedUsers || isLoadingSuggestedUsers;
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.ASSIGNEES_APPLY_PANEL_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserProfilesSelectable, {
    searchInputId: searchInputId,
    onSearchChange: term => {
      setSearchTerm(term);
    },
    onChange: handleSelectedAssignees,
    selectedStatusMessage: selectedStatusMessage,
    options: searchResultProfiles,
    selectedOptions: selectedAssignees,
    isLoading: isLoading,
    height: 'full',
    singleSelection: false,
    searchPlaceholder: i18n.ASSIGNEES_SEARCH_USERS,
    clearButtonLabel: i18n.ASSIGNEES_CLEAR_FILTERS,
    nullOptionLabel: i18n.ASSIGNEES_NO_ASSIGNEES
  }), onAssigneesApply && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": _test_ids.ASSIGNEES_APPLY_BUTTON_TEST_ID,
    fullWidth: true,
    size: "s",
    onClick: handleApplyButtonClick,
    isDisabled: isLoading
  }, i18n.ASSIGNEES_APPLY_BUTTON));
});
exports.AssigneesApplyPanel = AssigneesApplyPanel;
AssigneesApplyPanel.displayName = 'AssigneesPanel';