"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFlattenedLegendItems = void 0;
var _ecs_safety_helpers = require("../../../../../../common/endpoint/models/ecs_safety_helpers");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFlattenedLegendItems = ({
  buckets,
  colorPalette,
  flattenedBuckets,
  maxRiskSubAggregations,
  stackByField0,
  stackByField1
}) => {
  // create a map of bucket.key -> LegendItem[] from the raw buckets:
  const legendMap = (0, _.getLegendMap)({
    buckets,
    colorPalette,
    maxRiskSubAggregations,
    stackByField0
  });

  // append each flattened bucket to the appropriate parent in the legendMap:
  const combinedLegendItems = flattenedBuckets.reduce((acc, flattenedBucket) => {
    var _firstNonNullValue, _acc, _firstNonNullValue2;
    return {
      ...acc,
      [(_firstNonNullValue = (0, _ecs_safety_helpers.firstNonNullValue)(flattenedBucket.key)) !== null && _firstNonNullValue !== void 0 ? _firstNonNullValue : '']: [...((_acc = acc[(_firstNonNullValue2 = (0, _ecs_safety_helpers.firstNonNullValue)(flattenedBucket.key)) !== null && _firstNonNullValue2 !== void 0 ? _firstNonNullValue2 : '']) !== null && _acc !== void 0 ? _acc : []), (0, _.getLegendItemFromFlattenedBucket)({
        colorPalette,
        flattenedBucket,
        maxRiskSubAggregations,
        stackByField0,
        stackByField1
      })]
    };
  }, legendMap);

  // reduce all the legend items to a single array in the same order as the raw buckets:
  return buckets.reduce((acc, bucket) => {
    var _firstNonNullValue3;
    return [...acc, ...combinedLegendItems[(_firstNonNullValue3 = (0, _ecs_safety_helpers.firstNonNullValue)(bucket.key)) !== null && _firstNonNullValue3 !== void 0 ? _firstNonNullValue3 : '']];
  }, []);
};
exports.getFlattenedLegendItems = getFlattenedLegendItems;