"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTableColumns = exports.AlertCountByRuleByStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _constants = require("../../../../common/constants");
var _use_navigate_to_timeline = require("../../../overview/components/detection_response/hooks/use_navigate_to_timeline");
var _constants2 = require("../../../timelines/components/timeline/body/renderers/constants");
var _query_toggle = require("../../containers/query_toggle");
var _formatted_number = require("../formatted_number");
var _header_section = require("../header_section");
var _hover_visibility_container = require("../hover_visibility_container");
var _inspect = require("../inspect");
var _last_updated_at = require("../last_updated_at");
var _links = require("../links");
var _local_storage = require("../local_storage");
var _components = require("./components");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_alert_count_by_rule_by_status = require("./use_alert_count_by_rule_by_status");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STATUSES = ['open', 'acknowledged', 'closed'];
const ALERT_COUNT_BY_RULE_BY_STATUS = 'alerts-by-status-by-rule';
const LOCAL_STORAGE_KEY = 'alertCountByFieldNameWidgetSettings';
const StyledEuiPanel = (0, _common.euiStyled)(_eui.EuiPanel)`
  display: flex;
  flex-direction: column;
  position: relative;
  overflow: hidden;
  max-height: 308px;
`;
const AlertCountByRuleByStatus = /*#__PURE__*/_react.default.memo(({
  entityFilter,
  signalIndexName,
  additionalFilters
}) => {
  const {
    field,
    value
  } = entityFilter;
  const queryId = `${ALERT_COUNT_BY_RULE_BY_STATUS}-by-${field}`;
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(queryId);
  const {
    openTimelineWithFilters
  } = (0, _use_navigate_to_timeline.useNavigateToTimeline)();
  const [selectedStatusesByField, setSelectedStatusesByField] = (0, _local_storage.useLocalStorage)({
    defaultValue: {
      [field]: ['open']
    },
    key: LOCAL_STORAGE_KEY,
    isInvalidDefault: valueFromStorage => {
      return !valueFromStorage;
    }
  });
  const columns = (0, _react.useMemo)(() => {
    return getTableColumns(ruleName => {
      const timelineFilters = [];
      for (const status of selectedStatusesByField[field]) {
        timelineFilters.push([entityFilter, {
          field: _constants2.SIGNAL_RULE_NAME_FIELD_NAME,
          value: ruleName
        }, {
          field: _constants2.SIGNAL_STATUS_FIELD_NAME,
          value: status
        }]);
      }
      openTimelineWithFilters(timelineFilters);
    });
  }, [entityFilter, field, openTimelineWithFilters, selectedStatusesByField]);
  const updateSelection = (0, _react.useCallback)(selection => {
    setSelectedStatusesByField({
      ...selectedStatusesByField,
      [field]: selection
    });
  }, [field, selectedStatusesByField, setSelectedStatusesByField]);
  const {
    items,
    isLoading,
    updatedAt
  } = (0, _use_alert_count_by_rule_by_status.useAlertCountByRuleByStatus)({
    additionalFilters,
    field,
    value,
    queryId,
    statuses: selectedStatusesByField[field],
    skip: !toggleStatus,
    signalIndexName
  });
  return /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
    show: true,
    targetClassNames: [_inspect.BUTTON_CLASS]
  }, /*#__PURE__*/_react.default.createElement(StyledEuiPanel, {
    hasBorder: true,
    "data-test-subj": "alertCountByRulePanel"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: queryId,
    title: i18n.ALERTS_BY_RULE,
    titleSize: "m",
    toggleStatus: toggleStatus,
    toggleQuery: setToggleStatus,
    subtitle: /*#__PURE__*/_react.default.createElement(_last_updated_at.LastUpdatedAt, {
      updatedAt: updatedAt,
      isUpdating: isLoading
    })
  }, /*#__PURE__*/_react.default.createElement(_components.MultiSelectPopover, {
    title: i18n.Status,
    allItems: STATUSES,
    selectedItems: selectedStatusesByField[field] || ['open'],
    onSelectedItemsChange: selectedItems => updateSelection(selectedItems)
  })), toggleStatus && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    className: "eui-yScroll",
    "data-test-subj": "alertCountByRuleTable",
    columns: columns,
    items: items,
    loading: isLoading,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h3", null, i18n.NO_ALERTS_FOUND),
      titleSize: "xs"
    })
  })))));
});
exports.AlertCountByRuleByStatus = AlertCountByRuleByStatus;
AlertCountByRuleByStatus.displayName = 'AlertCountByStatus';
const getTableColumns = openRuleInTimelineWithAdditionalFields => [{
  field: 'ruleName',
  name: i18n.COLUMN_HEADER_RULE_NAME,
  'data-test-subj': i18n.COLUMN_HEADER_RULE_NAME,
  align: 'left',
  width: '67%',
  sortable: false,
  render: (ruleName, {
    uuid
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": `${ruleName}-tooltip`,
    title: i18n.TOOLTIP_TITLE,
    content: ruleName,
    anchorClassName: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
    "data-test-subj": "severityRuleAlertsTable-name",
    deepLinkId: _constants.SecurityPageName.rules,
    path: `id/${uuid}`
  }, ruleName))
}, {
  field: 'count',
  name: i18n.COLUMN_HEADER_COUNT,
  width: '33%',
  'data-test-subj': i18n.COLUMN_HEADER_COUNT,
  sortable: true,
  align: 'right',
  render: (count, {
    ruleName
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    disabled: count === 0,
    onClick: () => openRuleInTimelineWithAdditionalFields(ruleName)
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: count
  }))
}];
exports.getTableColumns = getTableColumns;