"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInsertTimeline = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _fp = require("lodash/fp");
var _link_to = require("../../../common/components/link_to");
var _use_selector = require("../../../common/hooks/use_selector");
var _timeline = require("../../../timelines/store/timeline");
var _types = require("../../../app/types");
var _actions = require("../../../timelines/store/timeline/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInsertTimeline = (value, onChange) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    formatUrl
  } = (0, _link_to.useFormatUrl)(_types.SecurityPageName.timelines);
  const insertTimeline = (0, _use_selector.useShallowEqualSelector)(_timeline.timelineSelectors.selectInsertTimeline);
  const handleOnTimelineChange = (0, _react.useCallback)((title, id, graphEventId) => {
    const url = formatUrl((0, _link_to.getTimelineUrl)(id !== null && id !== void 0 ? id : '', graphEventId), {
      absolute: true,
      skipSearch: true
    });
    let newValue = `[${title}](${url})`;
    // Leave a space between the previous value and the timeline url if the value is not empty.
    if (!(0, _fp.isEmpty)(value)) {
      newValue = `${value} ${newValue}`;
    }
    onChange(newValue);
  }, [value, onChange, formatUrl]);
  (0, _react.useEffect)(() => {
    if (insertTimeline != null && value != null) {
      dispatch(_timeline.timelineActions.showTimeline({
        id: insertTimeline.timelineId,
        show: false
      }));
      handleOnTimelineChange(insertTimeline.timelineTitle, insertTimeline.timelineSavedObjectId, insertTimeline.graphEventId);
      dispatch((0, _actions.setInsertTimeline)(null));
    }
  }, [insertTimeline, dispatch, handleOnTimelineChange, value]);
  return {
    handleOnTimelineChange
  };
};
exports.useInsertTimeline = useInsertTimeline;