"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.customCodeBlockLanguagePlugin = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const customCodeBlockLanguagePlugin = () => {
  const visitor = (node, parent) => {
    if ('children' in node) {
      const nodeAsParent = node;
      nodeAsParent.children.forEach(child => {
        visitor(child, nodeAsParent);
      });
    }
    if (node.type === 'code' && (node.lang === 'eql' || node.lang === 'esql' || node.lang === 'kql' || node.lang === 'dsl' || node.lang === 'json')) {
      node.type = 'customCodeBlock';
    }
  };
  return tree => {
    visitor(tree);
  };
};
exports.customCodeBlockLanguagePlugin = customCodeBlockLanguagePlugin;