"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BASE_SECURITY_QUICK_PROMPTS = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
var _prompt_contexts = require("../prompt_contexts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Global list of QuickPrompts intended to be used throughout Security Solution.
 * Useful if wanting to see all available QuickPrompts in one place, or if needing
 * to reference when constructing a new chat window to include a QuickPrompt.
 */
const BASE_SECURITY_QUICK_PROMPTS = [{
  title: i18n.ALERT_SUMMARIZATION_TITLE,
  prompt: i18n.ALERT_SUMMARIZATION_PROMPT,
  color: '#F68FBE',
  categories: [_prompt_contexts.PROMPT_CONTEXT_ALERT_CATEGORY],
  isDefault: true
}, {
  title: i18n.ESQL_QUERY_GENERATION_TITLE,
  prompt: i18n.ESQL_QUERY_GENERATION_PROMPT,
  color: '#9170B8',
  categories: [_prompt_contexts.KNOWLEDGE_BASE_CATEGORY],
  isDefault: true
}, {
  title: i18n.RULE_CREATION_TITLE,
  prompt: i18n.RULE_CREATION_PROMPT,
  categories: [_prompt_contexts.PROMPT_CONTEXT_DETECTION_RULES_CATEGORY],
  color: '#7DDED8',
  isDefault: true
}, {
  title: i18n.WORKFLOW_ANALYSIS_TITLE,
  prompt: i18n.WORKFLOW_ANALYSIS_PROMPT,
  color: '#36A2EF',
  isDefault: true
}, {
  title: i18n.THREAT_INVESTIGATION_GUIDES_TITLE,
  prompt: i18n.THREAT_INVESTIGATION_GUIDES_PROMPT,
  categories: [_prompt_contexts.PROMPT_CONTEXT_EVENT_CATEGORY],
  color: '#F3D371',
  isDefault: true
}, {
  title: i18n.SPL_QUERY_CONVERSION_TITLE,
  prompt: i18n.SPL_QUERY_CONVERSION_PROMPT,
  color: '#BADA55',
  isDefault: true
}, {
  title: i18n.AUTOMATION_TITLE,
  prompt: i18n.AUTOMATION_PROMPT,
  color: '#FFA500',
  isDefault: true
}];
exports.BASE_SECURITY_QUICK_PROMPTS = BASE_SECURITY_QUICK_PROMPTS;