"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopValuesPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _reactUse = require("react-use");
var _top_n = require("../../../common/components/top_n");
var _sourcerer = require("../../../common/containers/sourcerer");
var _kibana = require("../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TopValuesPopover = /*#__PURE__*/_react.default.memo(() => {
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const {
    browserFields,
    indexPattern
  } = (0, _sourcerer.useSourcererDataView)((0, _sourcerer.getScopeFromPath)(pathname));
  const {
    services: {
      topValuesPopover
    }
  } = (0, _kibana.useKibana)();
  const data = (0, _reactUse.useObservable)(topValuesPopover.getObservable());
  const onClose = (0, _react.useCallback)(() => {
    topValuesPopover.closePopover();
  }, [topValuesPopover]);
  if (!data || !data.nodeRef) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
    isOpen: true,
    button: data.nodeRef,
    closePopover: onClose,
    anchorPosition: 'downCenter',
    hasArrow: false,
    repositionOnScroll: true,
    ownFocus: true,
    attachToAnchor: false
  }, /*#__PURE__*/_react.default.createElement(_top_n.StatefulTopN, {
    field: data.fieldName,
    showLegend: true,
    scopeId: data.scopeId,
    toggleTopN: onClose,
    indexPattern: indexPattern,
    browserFields: browserFields
  }));
});
exports.TopValuesPopover = TopValuesPopover;
TopValuesPopover.displayName = 'TopValuesPopover';