"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityCellActionsTrigger = exports.SecurityCellActionType = exports.EsqlInTimelineTrigger = exports.EsqlInTimelineAction = exports.DefaultCellActionTypes = void 0;
var _constants = require("@kbn/cell-actions/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let SecurityCellActionsTrigger;
exports.SecurityCellActionsTrigger = SecurityCellActionsTrigger;
(function (SecurityCellActionsTrigger) {
  SecurityCellActionsTrigger["DEFAULT"] = "security-default-cellActions";
  SecurityCellActionsTrigger["DETAILS_FLYOUT"] = "security-detailsFlyout-cellActions";
  SecurityCellActionsTrigger["ALERTS_COUNT"] = "security-alertsCount-cellActions";
})(SecurityCellActionsTrigger || (exports.SecurityCellActionsTrigger = SecurityCellActionsTrigger = {}));
let EsqlInTimelineTrigger;
exports.EsqlInTimelineTrigger = EsqlInTimelineTrigger;
(function (EsqlInTimelineTrigger) {
  EsqlInTimelineTrigger["HISTOGRAM_TRIGGER"] = "security-discoverInTimeline-histogramTrigger";
})(EsqlInTimelineTrigger || (exports.EsqlInTimelineTrigger = EsqlInTimelineTrigger = {}));
let EsqlInTimelineAction;
exports.EsqlInTimelineAction = EsqlInTimelineAction;
(function (EsqlInTimelineAction) {
  EsqlInTimelineAction["VIS_FILTER_ACTION"] = "security-discoverInTimeline-visFilterAction";
})(EsqlInTimelineAction || (exports.EsqlInTimelineAction = EsqlInTimelineAction = {}));
let SecurityCellActionType;
exports.SecurityCellActionType = SecurityCellActionType;
(function (SecurityCellActionType) {
  SecurityCellActionType["FILTER"] = "security-cellAction-type-filter";
  SecurityCellActionType["COPY"] = "security-cellAction-type-copyToClipboard";
  SecurityCellActionType["ADD_TO_TIMELINE"] = "security-cellAction-type-addToTimeline";
  SecurityCellActionType["INVESTIGATE_IN_NEW_TIMELINE"] = "security-cellAction-type-investigateInNewTimeline";
  SecurityCellActionType["SHOW_TOP_N"] = "security-cellAction-type-showTopN";
  SecurityCellActionType["TOGGLE_COLUMN"] = "security-cellAction-type-toggleColumn";
})(SecurityCellActionType || (exports.SecurityCellActionType = SecurityCellActionType = {}));
const DefaultCellActionTypes = {
  FILTER: _constants.FILTER_CELL_ACTION_TYPE,
  COPY: _constants.COPY_CELL_ACTION_TYPE
};
exports.DefaultCellActionTypes = DefaultCellActionTypes;