"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInvestigateInNewTimelineCellActionFactory = void 0;
var _cellActions = require("@kbn/cell-actions");
var _utils = require("@kbn/cell-actions/src/actions/utils");
var _translations = require("@kbn/cell-actions/src/actions/translations");
var _timeline = require("../../../timelines/store/timeline");
var _actions = require("../../../timelines/store/timeline/actions");
var _types = require("../../../../common/types");
var _utils2 = require("../../utils");
var _constants = require("../constants");
var _data_provider = require("../data_provider");
var _constants2 = require("../../constants");
var _defaults = require("../../../timelines/store/timeline/defaults");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createInvestigateInNewTimelineCellActionFactory = (0, _cellActions.createCellActionFactory)(({
  store,
  services
}) => {
  const {
    notifications: notificationsService
  } = services;
  return {
    type: _constants2.SecurityCellActionType.INVESTIGATE_IN_NEW_TIMELINE,
    getIconType: () => _constants.ADD_TO_TIMELINE_ICON,
    getDisplayName: () => _constants.INVESTIGATE_IN_TIMELINE,
    getDisplayNameTooltip: () => _constants.INVESTIGATE_IN_TIMELINE,
    isCompatible: async ({
      data
    }) => {
      var _data$;
      const field = (_data$ = data[0]) === null || _data$ === void 0 ? void 0 : _data$.field;
      return data.length === 1 &&
      // TODO Add support for multiple values
      (0, _utils2.fieldHasCellActions)(field.name) && (0, _data_provider.isValidDataProviderField)(field.name, field.type) && (0, _utils.isTypeSupportedByDefaultActions)(field.type);
    },
    execute: async ({
      data,
      metadata
    }) => {
      var _data$2, _data$3, _createDataProviders;
      const field = (_data$2 = data[0]) === null || _data$2 === void 0 ? void 0 : _data$2.field;
      const rawValue = (_data$3 = data[0]) === null || _data$3 === void 0 ? void 0 : _data$3.value;
      const value = (0, _utils.filterOutNullableValues)((0, _utils.valueToArray)(rawValue));
      if (!(0, _utils.isValueSupportedByDefaultActions)(value)) {
        notificationsService.toasts.addWarning({
          title: _translations.ACTION_INCOMPATIBLE_VALUE_WARNING
        });
        return;
      }
      const dataProviders = (_createDataProviders = (0, _data_provider.createDataProviders)({
        contextId: _types.TimelineId.active,
        fieldType: field.type,
        values: value,
        field: field.name,
        negate: (metadata === null || metadata === void 0 ? void 0 : metadata.negateFilters) === true
      })) !== null && _createDataProviders !== void 0 ? _createDataProviders : [];
      for (const andFilter of (_metadata$andFilters = metadata === null || metadata === void 0 ? void 0 : metadata.andFilters) !== null && _metadata$andFilters !== void 0 ? _metadata$andFilters : []) {
        var _metadata$andFilters, _createDataProviders2;
        const andDataProviders = (_createDataProviders2 = (0, _data_provider.createDataProviders)({
          contextId: _types.TimelineId.active,
          field: andFilter.field,
          values: andFilter.value
        })) !== null && _createDataProviders2 !== void 0 ? _createDataProviders2 : [];
        if (andDataProviders) {
          for (const dataProvider of dataProviders) {
            dataProvider.and.push(...andDataProviders);
          }
        }
      }
      if (dataProviders.length > 0) {
        // clear timeline
        store.dispatch(_timeline.timelineActions.createTimeline({
          ..._defaults.timelineDefaults,
          id: _types.TimelineId.active
        }));
        store.dispatch((0, _actions.showTimeline)({
          id: _types.TimelineId.active,
          show: true
        }));
        store.dispatch((0, _actions.addProvider)({
          id: _types.TimelineId.active,
          providers: dataProviders
        }));
      } else {
        notificationsService.toasts.addWarning({
          title: _constants.ADD_TO_TIMELINE_FAILED_TITLE,
          text: _constants.ADD_TO_TIMELINE_FAILED_TEXT
        });
      }
    }
  };
});
exports.createInvestigateInNewTimelineCellActionFactory = createInvestigateInNewTimelineCellActionFactory;