"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.riskWeightsSchema = exports.riskWeightSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _utils = require("../utils");
var _types = require("./types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hostWeight = t.type({
  host: _securitysolutionIoTsTypes.NumberBetweenZeroAndOneInclusive
});
const userWeight = t.type({
  user: _securitysolutionIoTsTypes.NumberBetweenZeroAndOneInclusive
});
const identifierWeights = t.union([t.exact(t.intersection([hostWeight, userWeight])), t.exact(t.intersection([hostWeight, t.partial({
  user: t.undefined
})])), t.exact(t.intersection([userWeight, t.partial({
  host: t.undefined
})]))]);
const riskCategories = (0, _utils.fromEnum)('riskCategories', _types.RiskCategories);
const globalRiskWeightSchema = t.intersection([t.exact(t.type({
  type: t.literal(_types.RiskWeightTypes.global)
})), identifierWeights]);
const riskCategoryRiskWeightSchema = t.intersection([t.exact(t.type({
  type: t.literal(_types.RiskWeightTypes.riskCategory),
  value: riskCategories
})), identifierWeights]);
const riskWeightSchema = t.union([globalRiskWeightSchema, riskCategoryRiskWeightSchema]);
exports.riskWeightSchema = riskWeightSchema;
const riskWeightsSchema = t.array(riskWeightSchema);
exports.riskWeightsSchema = riskWeightsSchema;