"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.siemGuideId = exports.getSiemGuideConfig = exports.defaultGuideTranslations = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const siemGuideId = 'siem';
exports.siemGuideId = siemGuideId;
const defaultGuideTranslations = {
  title: i18n.TITLE,
  description: i18n.DESCRIPTION,
  docs: i18n.DOCS,
  steps: {
    add_data: {
      title: i18n.ADD_DATA_TITLE,
      description: i18n.ADD_DATA_DESCRIPTION
    },
    rules: {
      title: i18n.RULES_TITLE,
      description: i18n.RULES_DESCRIPTION,
      manualCompletion: {
        title: i18n.RULES_MANUAL_TITLE,
        description: i18n.RULES_MANUAL_DESCRIPTION
      }
    },
    alertsCases: {
      title: i18n.CASES_TITLE,
      description: i18n.CASES_DESCRIPTION,
      manualCompletion: {
        title: i18n.CASES_MANUAL_TITLE,
        description: i18n.CASES_MANUAL_DESCRIPTION
      }
    }
  }
};
exports.defaultGuideTranslations = defaultGuideTranslations;
const getSiemGuideConfig = (launchDarkly = defaultGuideTranslations) => {
  var _launchDarkly$title, _launchDarkly$descrip, _launchDarkly$docs, _launchDarkly$steps$a, _launchDarkly$steps, _launchDarkly$steps$a2, _launchDarkly$steps$a3, _launchDarkly$steps2, _launchDarkly$steps2$, _launchDarkly$steps$r, _launchDarkly$steps3, _launchDarkly$steps3$, _launchDarkly$steps$r2, _launchDarkly$steps4, _launchDarkly$steps4$, _launchDarkly$steps$r3, _launchDarkly$steps5, _launchDarkly$steps5$, _launchDarkly$steps5$2, _launchDarkly$steps$r4, _launchDarkly$steps6, _launchDarkly$steps6$, _launchDarkly$steps6$2, _launchDarkly$steps$a4, _launchDarkly$steps7, _launchDarkly$steps7$, _launchDarkly$steps$a5, _launchDarkly$steps8, _launchDarkly$steps8$, _launchDarkly$steps$a6, _launchDarkly$steps9, _launchDarkly$steps9$, _launchDarkly$steps9$2, _launchDarkly$steps$a7, _launchDarkly$steps10, _launchDarkly$steps11, _launchDarkly$steps12;
  return {
    // check each launchDarkly property in case data is misformatted
    title: (_launchDarkly$title = launchDarkly.title) !== null && _launchDarkly$title !== void 0 ? _launchDarkly$title : defaultGuideTranslations.title,
    guideName: 'Security',
    telemetryId: siemGuideId,
    completedGuideRedirectLocation: {
      appID: 'securitySolutionUI',
      path: '/dashboards'
    },
    description: (_launchDarkly$descrip = launchDarkly.description) !== null && _launchDarkly$descrip !== void 0 ? _launchDarkly$descrip : defaultGuideTranslations.description,
    docs: {
      text: (_launchDarkly$docs = launchDarkly.docs) !== null && _launchDarkly$docs !== void 0 ? _launchDarkly$docs : defaultGuideTranslations.docs,
      url: 'https://www.elastic.co/guide/en/security/current/ingest-data.html'
    },
    steps: [{
      id: 'add_data',
      title: (_launchDarkly$steps$a = (_launchDarkly$steps = launchDarkly.steps) === null || _launchDarkly$steps === void 0 ? void 0 : (_launchDarkly$steps$a2 = _launchDarkly$steps.add_data) === null || _launchDarkly$steps$a2 === void 0 ? void 0 : _launchDarkly$steps$a2.title) !== null && _launchDarkly$steps$a !== void 0 ? _launchDarkly$steps$a : defaultGuideTranslations.steps.add_data.title,
      description: {
        descriptionText: (_launchDarkly$steps$a3 = (_launchDarkly$steps2 = launchDarkly.steps) === null || _launchDarkly$steps2 === void 0 ? void 0 : (_launchDarkly$steps2$ = _launchDarkly$steps2.add_data) === null || _launchDarkly$steps2$ === void 0 ? void 0 : _launchDarkly$steps2$.description) !== null && _launchDarkly$steps$a3 !== void 0 ? _launchDarkly$steps$a3 : defaultGuideTranslations.steps.add_data.description,
        linkUrl: 'https://docs.elastic.co/en/integrations/endpoint',
        isLinkExternal: true,
        linkText: i18n.LINK_TEXT
      },
      integration: 'endpoint',
      location: {
        appID: 'integrations',
        path: '/detail/endpoint/overview'
      }
    }, {
      id: 'rules',
      title: (_launchDarkly$steps$r = (_launchDarkly$steps3 = launchDarkly.steps) === null || _launchDarkly$steps3 === void 0 ? void 0 : (_launchDarkly$steps3$ = _launchDarkly$steps3.rules) === null || _launchDarkly$steps3$ === void 0 ? void 0 : _launchDarkly$steps3$.title) !== null && _launchDarkly$steps$r !== void 0 ? _launchDarkly$steps$r : defaultGuideTranslations.steps.rules.title,
      description: (_launchDarkly$steps$r2 = (_launchDarkly$steps4 = launchDarkly.steps) === null || _launchDarkly$steps4 === void 0 ? void 0 : (_launchDarkly$steps4$ = _launchDarkly$steps4.rules) === null || _launchDarkly$steps4$ === void 0 ? void 0 : _launchDarkly$steps4$.description) !== null && _launchDarkly$steps$r2 !== void 0 ? _launchDarkly$steps$r2 : defaultGuideTranslations.steps.rules.description,
      manualCompletion: {
        title: (_launchDarkly$steps$r3 = (_launchDarkly$steps5 = launchDarkly.steps) === null || _launchDarkly$steps5 === void 0 ? void 0 : (_launchDarkly$steps5$ = _launchDarkly$steps5.rules) === null || _launchDarkly$steps5$ === void 0 ? void 0 : (_launchDarkly$steps5$2 = _launchDarkly$steps5$.manualCompletion) === null || _launchDarkly$steps5$2 === void 0 ? void 0 : _launchDarkly$steps5$2.title) !== null && _launchDarkly$steps$r3 !== void 0 ? _launchDarkly$steps$r3 : defaultGuideTranslations.steps.rules.manualCompletion.title,
        description: (_launchDarkly$steps$r4 = (_launchDarkly$steps6 = launchDarkly.steps) === null || _launchDarkly$steps6 === void 0 ? void 0 : (_launchDarkly$steps6$ = _launchDarkly$steps6.rules) === null || _launchDarkly$steps6$ === void 0 ? void 0 : (_launchDarkly$steps6$2 = _launchDarkly$steps6$.manualCompletion) === null || _launchDarkly$steps6$2 === void 0 ? void 0 : _launchDarkly$steps6$2.description) !== null && _launchDarkly$steps$r4 !== void 0 ? _launchDarkly$steps$r4 : defaultGuideTranslations.steps.rules.manualCompletion.description
      },
      location: {
        appID: 'securitySolutionUI',
        path: '/rules'
      }
    }, {
      id: 'alertsCases',
      title: (_launchDarkly$steps$a4 = (_launchDarkly$steps7 = launchDarkly.steps) === null || _launchDarkly$steps7 === void 0 ? void 0 : (_launchDarkly$steps7$ = _launchDarkly$steps7.alertsCases) === null || _launchDarkly$steps7$ === void 0 ? void 0 : _launchDarkly$steps7$.title) !== null && _launchDarkly$steps$a4 !== void 0 ? _launchDarkly$steps$a4 : defaultGuideTranslations.steps.alertsCases.title,
      description: (_launchDarkly$steps$a5 = (_launchDarkly$steps8 = launchDarkly.steps) === null || _launchDarkly$steps8 === void 0 ? void 0 : (_launchDarkly$steps8$ = _launchDarkly$steps8.alertsCases) === null || _launchDarkly$steps8$ === void 0 ? void 0 : _launchDarkly$steps8$.description) !== null && _launchDarkly$steps$a5 !== void 0 ? _launchDarkly$steps$a5 : defaultGuideTranslations.steps.alertsCases.description,
      location: {
        appID: 'securitySolutionUI',
        path: '/alerts'
      },
      manualCompletion: {
        title: (_launchDarkly$steps$a6 = (_launchDarkly$steps9 = launchDarkly.steps) === null || _launchDarkly$steps9 === void 0 ? void 0 : (_launchDarkly$steps9$ = _launchDarkly$steps9.alertsCases) === null || _launchDarkly$steps9$ === void 0 ? void 0 : (_launchDarkly$steps9$2 = _launchDarkly$steps9$.manualCompletion) === null || _launchDarkly$steps9$2 === void 0 ? void 0 : _launchDarkly$steps9$2.title) !== null && _launchDarkly$steps$a6 !== void 0 ? _launchDarkly$steps$a6 : defaultGuideTranslations.steps.alertsCases.manualCompletion.title,
        description: (_launchDarkly$steps$a7 = (_launchDarkly$steps10 = launchDarkly.steps) === null || _launchDarkly$steps10 === void 0 ? void 0 : (_launchDarkly$steps11 = _launchDarkly$steps10.alertsCases) === null || _launchDarkly$steps11 === void 0 ? void 0 : (_launchDarkly$steps12 = _launchDarkly$steps11.manualCompletion) === null || _launchDarkly$steps12 === void 0 ? void 0 : _launchDarkly$steps12.description) !== null && _launchDarkly$steps$a7 !== void 0 ? _launchDarkly$steps$a7 : defaultGuideTranslations.steps.alertsCases.manualCompletion.description
      }
    }]
  };
};
exports.getSiemGuideConfig = getSiemGuideConfig;