"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.catchAxiosErrorFormatAndThrow = exports.FormattedAxiosError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _axios = require("axios");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @typescript-eslint/no-explicit-any */

class FormattedAxiosError extends Error {
  constructor(axiosError) {
    var _axiosError$response, _axiosError$response2, _axiosError$config$me, _axiosError$config, _axiosError$config$ur, _axiosError$config2, _axiosError$config$da, _axiosError$config3, _axiosError$response$, _axiosError$response3, _axiosError$response$2, _axiosError$response4, _axiosError$response5;
    super(`${axiosError.message}${axiosError !== null && axiosError !== void 0 && (_axiosError$response = axiosError.response) !== null && _axiosError$response !== void 0 && _axiosError$response.data ? `: ${JSON.stringify(axiosError === null || axiosError === void 0 ? void 0 : (_axiosError$response2 = axiosError.response) === null || _axiosError$response2 === void 0 ? void 0 : _axiosError$response2.data)}` : ''}`);
    (0, _defineProperty2.default)(this, "request", void 0);
    (0, _defineProperty2.default)(this, "response", void 0);
    this.request = {
      method: (_axiosError$config$me = (_axiosError$config = axiosError.config) === null || _axiosError$config === void 0 ? void 0 : _axiosError$config.method) !== null && _axiosError$config$me !== void 0 ? _axiosError$config$me : '?',
      url: (_axiosError$config$ur = (_axiosError$config2 = axiosError.config) === null || _axiosError$config2 === void 0 ? void 0 : _axiosError$config2.url) !== null && _axiosError$config$ur !== void 0 ? _axiosError$config$ur : '?',
      data: (_axiosError$config$da = (_axiosError$config3 = axiosError.config) === null || _axiosError$config3 === void 0 ? void 0 : _axiosError$config3.data) !== null && _axiosError$config$da !== void 0 ? _axiosError$config$da : ''
    };
    this.response = {
      status: (_axiosError$response$ = axiosError === null || axiosError === void 0 ? void 0 : (_axiosError$response3 = axiosError.response) === null || _axiosError$response3 === void 0 ? void 0 : _axiosError$response3.status) !== null && _axiosError$response$ !== void 0 ? _axiosError$response$ : 0,
      statusText: (_axiosError$response$2 = axiosError === null || axiosError === void 0 ? void 0 : (_axiosError$response4 = axiosError.response) === null || _axiosError$response4 === void 0 ? void 0 : _axiosError$response4.statusText) !== null && _axiosError$response$2 !== void 0 ? _axiosError$response$2 : '',
      data: axiosError === null || axiosError === void 0 ? void 0 : (_axiosError$response5 = axiosError.response) === null || _axiosError$response5 === void 0 ? void 0 : _axiosError$response5.data
    };
    this.name = this.constructor.name;
  }
  toJSON() {
    return {
      message: this.message,
      request: this.request,
      response: this.response
    };
  }
  toString() {
    return JSON.stringify(this.toJSON(), null, 2);
  }
}

/**
 * Used with `promise.catch()`, it will format the Axios error to a new error and will re-throw
 * @param error
 */
exports.FormattedAxiosError = FormattedAxiosError;
const catchAxiosErrorFormatAndThrow = error => {
  if (error instanceof _axios.AxiosError) {
    throw new FormattedAxiosError(error);
  }
  throw error;
};
exports.catchAxiosErrorFormatAndThrow = catchAxiosErrorFormatAndThrow;