"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usersRiskScoreRequestOptionsSchema = exports.riskScoreRequestOptionsSchema = exports.hostsRiskScoreRequestOptionsSchema = exports.RiskScoreFields = void 0;
var _zod = require("zod");
var _factory_query_type = require("../model/factory_query_type");
var _request_basic_options = require("../model/request_basic_options");
var _sort = require("../model/sort");
var _timerange = require("../model/timerange");
var _risk_score_entity = require("./model/risk_score_entity");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let RiskScoreFields;
exports.RiskScoreFields = RiskScoreFields;
(function (RiskScoreFields) {
  RiskScoreFields["timestamp"] = "@timestamp";
  RiskScoreFields["hostName"] = "host.name";
  RiskScoreFields["hostRiskScore"] = "host.risk.calculated_score_norm";
  RiskScoreFields["hostRisk"] = "host.risk.calculated_level";
  RiskScoreFields["userName"] = "user.name";
  RiskScoreFields["userRiskScore"] = "user.risk.calculated_score_norm";
  RiskScoreFields["userRisk"] = "user.risk.calculated_level";
  RiskScoreFields["alertsCount"] = "alertsCount";
})(RiskScoreFields || (exports.RiskScoreFields = RiskScoreFields = {}));
const baseRiskScoreRequestOptionsSchema = _request_basic_options.requestBasicOptionsSchema.extend({
  alertsTimerange: _timerange.timerange.optional(),
  riskScoreEntity: _risk_score_entity.riskScoreEntity,
  includeAlertsCount: _zod.z.boolean().optional(),
  onlyLatest: _zod.z.boolean().optional(),
  pagination: _zod.z.object({
    cursorStart: _zod.z.number(),
    querySize: _zod.z.number()
  }).optional(),
  sort: _sort.sort.removeDefault().extend({
    field: _zod.z.enum([RiskScoreFields.timestamp, RiskScoreFields.hostName, RiskScoreFields.hostRiskScore, RiskScoreFields.hostRisk, RiskScoreFields.userName, RiskScoreFields.userRiskScore, RiskScoreFields.userRisk, RiskScoreFields.alertsCount])
  }).optional()
});
const hostsRiskScoreRequestOptionsSchema = baseRiskScoreRequestOptionsSchema.extend({
  factoryQueryType: _zod.z.literal(_factory_query_type.RiskQueries.hostsRiskScore)
});
exports.hostsRiskScoreRequestOptionsSchema = hostsRiskScoreRequestOptionsSchema;
const usersRiskScoreRequestOptionsSchema = baseRiskScoreRequestOptionsSchema.extend({
  factoryQueryType: _zod.z.literal(_factory_query_type.RiskQueries.usersRiskScore)
});
exports.usersRiskScoreRequestOptionsSchema = usersRiskScoreRequestOptionsSchema;
const riskScoreRequestOptionsSchema = _zod.z.union([hostsRiskScoreRequestOptionsSchema, usersRiskScoreRequestOptionsSchema]);
exports.riskScoreRequestOptionsSchema = riskScoreRequestOptionsSchema;