"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runtimeMappings = void 0;
var _zod = require("zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const runtimeMappings = _zod.z.record(_zod.z.object({
  type: _zod.z.union([_zod.z.literal('boolean'), _zod.z.literal('date'), _zod.z.literal('double'), _zod.z.literal('geo_point'), _zod.z.literal('ip'), _zod.z.literal('keyword'), _zod.z.literal('long'), _zod.z.literal('lookup')]),
  script: _zod.z.union([_zod.z.string(), _zod.z.object({
    source: _zod.z.string()
  }), _zod.z.object({
    id: _zod.z.string(),
    params: _zod.z.record(_zod.z.any())
  })]).optional(),
  fetch_fields: _zod.z.array(_zod.z.string()).optional(),
  format: _zod.z.string().optional(),
  input_field: _zod.z.string().optional(),
  target_field: _zod.z.string().optional(),
  target_index: _zod.z.string().optional()
})).optional();
exports.runtimeMappings = runtimeMappings;