"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.matrixHistogramSchema = exports.MatrixHistogramType = void 0;
var _zod = require("zod");
var _factory_query_type = require("../model/factory_query_type");
var _inspect = require("../model/inspect");
var _request_basic_options = require("../model/request_basic_options");
var _runtime_mappings = require("../model/runtime_mappings");
var _timerange = require("../model/timerange");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let MatrixHistogramType;
exports.MatrixHistogramType = MatrixHistogramType;
(function (MatrixHistogramType) {
  MatrixHistogramType["authentications"] = "authentications";
  MatrixHistogramType["anomalies"] = "anomalies";
  MatrixHistogramType["events"] = "events";
  MatrixHistogramType["alerts"] = "alerts";
  MatrixHistogramType["dns"] = "dns";
  MatrixHistogramType["preview"] = "preview";
})(MatrixHistogramType || (exports.MatrixHistogramType = MatrixHistogramType = {}));
const matrixHistogramSchema = _request_basic_options.requestBasicOptionsSchema.extend({
  histogramType: _zod.z.enum([MatrixHistogramType.alerts, MatrixHistogramType.anomalies, MatrixHistogramType.authentications, MatrixHistogramType.dns, MatrixHistogramType.events, MatrixHistogramType.preview]),
  stackByField: _zod.z.string().optional(),
  threshold: _zod.z.object({
    field: _zod.z.array(_zod.z.string()),
    value: _zod.z.string(),
    cardinality: _zod.z.object({
      field: _zod.z.array(_zod.z.string()),
      value: _zod.z.string()
    }).optional()
  }).optional(),
  inspect: _inspect.inspect,
  isPtrIncluded: _zod.z.boolean().default(false),
  includeMissingData: _zod.z.boolean().default(true),
  runtimeMappings: _runtime_mappings.runtimeMappings,
  timerange: _timerange.timerange,
  factoryQueryType: _zod.z.literal(_factory_query_type.MatrixHistogramQuery)
});
exports.matrixHistogramSchema = matrixHistogramSchema;