"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hostDetailsSchema = void 0;
var _zod = require("zod");
var _factory_query_type = require("../model/factory_query_type");
var _inspect = require("../model/inspect");
var _pagination = require("../model/pagination");
var _request_basic_options = require("../model/request_basic_options");
var _timerange = require("../model/timerange");
var _sort = require("./model/sort");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hostDetailsSchema = _request_basic_options.requestBasicOptionsSchema.extend({
  hostName: _zod.z.string(),
  skip: _zod.z.boolean().optional(),
  inspect: _inspect.inspect,
  pagination: _pagination.pagination.optional(),
  timerange: _timerange.timerange,
  sort: _sort.sort,
  factoryQueryType: _zod.z.literal(_factory_query_type.HostsQueries.details)
});
exports.hostDetailsSchema = hostDetailsSchema;