"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UploadActionRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _base = require("./common/base");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UploadActionRequestSchema = {
  body: _configSchema.schema.object({
    ..._base.BaseActionRequestSchema,
    parameters: _configSchema.schema.object({
      overwrite: _configSchema.schema.maybe(_configSchema.schema.boolean({
        defaultValue: false
      }))
    }),
    file: _configSchema.schema.stream()
  })
};

/** Type used by the server's API for `upload` action */

/**
 * Type used on the UI side. The `file` definition is different on the UI side, thus the
 * need for a separate type.
 */
exports.UploadActionRequestSchema = UploadActionRequestSchema;