"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetRuleExecutionEventsResponse = exports.GetRuleExecutionEventsRequestQuery = exports.GetRuleExecutionEventsRequestParams = void 0;
var _zod = require("zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _execution_event = require("../../model/execution_event.gen");
var _sorting = require("../../../model/sorting.gen");
var _pagination = require("../../../model/pagination.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 */

const GetRuleExecutionEventsRequestQuery = _zod.z.object({
  /**
   * Include events of matching the search term. If omitted, all events will be included.
   */
  search_term: _zod.z.string().optional(),
  /**
   * Include events of the specified types. If omitted, all types of events will be included.
   */
  event_types: (0, _zodHelpers.ArrayFromString)(_execution_event.RuleExecutionEventType).optional().default([]),
  /**
   * Include events having these log levels. If omitted, events of all levels will be included.
   */
  log_levels: (0, _zodHelpers.ArrayFromString)(_execution_event.LogLevel).optional().default([]),
  /**
   * Start date of the time range to query
   */
  date_start: _zod.z.string().datetime().optional(),
  /**
   * End date of the time range to query
   */
  date_end: _zod.z.string().datetime().optional(),
  /**
   * Sort order to sort results by
   */
  sort_order: _sorting.SortOrder.optional().default('desc'),
  /**
   * Page number to return
   */
  page: _zod.z.coerce.number().int().optional().default(1),
  /**
   * Number of results per page
   */
  per_page: _zod.z.coerce.number().int().optional().default(20)
});
exports.GetRuleExecutionEventsRequestQuery = GetRuleExecutionEventsRequestQuery;
const GetRuleExecutionEventsRequestParams = _zod.z.object({
  ruleId: _zod.z.string().min(1)
});
exports.GetRuleExecutionEventsRequestParams = GetRuleExecutionEventsRequestParams;
const GetRuleExecutionEventsResponse = _zod.z.object({
  events: _zod.z.array(_execution_event.RuleExecutionEvent),
  pagination: _pagination.PaginationResult
});
exports.GetRuleExecutionEventsResponse = GetRuleExecutionEventsResponse;