"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleExecutionSummary = void 0;
var _zod = require("zod");
var _execution_status = require("./execution_status.gen");
var _execution_metrics = require("./execution_metrics.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 */

const RuleExecutionSummary = _zod.z.object({
  last_execution: _zod.z.object({
    /**
     * Date of the last execution
     */
    date: _zod.z.string().datetime(),
    /**
     * Status of the last execution
     */
    status: _execution_status.RuleExecutionStatus,
    status_order: _execution_status.RuleExecutionStatusOrder,
    message: _zod.z.string(),
    metrics: _execution_metrics.RuleExecutionMetrics
  })
});
exports.RuleExecutionSummary = RuleExecutionSummary;