"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSuppressionMissingFieldsStrategyEnum = exports.AlertSuppressionMissingFieldsStrategy = exports.AlertSuppressionGroupBy = exports.AlertSuppressionCamel = exports.AlertSuppression = void 0;
var _zod = require("zod");
var _common_attributes = require("../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 */

/**
  * Describes how alerts will be generated for documents with missing suppress by fields:
doNotSuppress - per each document a separate alert will be created
suppress - only alert will be created per suppress by bucket
  */

const AlertSuppressionMissingFieldsStrategy = _zod.z.enum(['doNotSuppress', 'suppress']);
exports.AlertSuppressionMissingFieldsStrategy = AlertSuppressionMissingFieldsStrategy;
const AlertSuppressionMissingFieldsStrategyEnum = AlertSuppressionMissingFieldsStrategy.enum;
exports.AlertSuppressionMissingFieldsStrategyEnum = AlertSuppressionMissingFieldsStrategyEnum;
const AlertSuppressionGroupBy = _zod.z.array(_zod.z.string()).min(1).max(3);
exports.AlertSuppressionGroupBy = AlertSuppressionGroupBy;
const AlertSuppression = _zod.z.object({
  group_by: AlertSuppressionGroupBy,
  duration: _common_attributes.AlertSuppressionDuration.optional(),
  missing_fields_strategy: AlertSuppressionMissingFieldsStrategy.optional()
});
exports.AlertSuppression = AlertSuppression;
const AlertSuppressionCamel = _zod.z.object({
  groupBy: AlertSuppressionGroupBy,
  duration: _common_attributes.AlertSuppressionDuration.optional(),
  missingFieldsStrategy: AlertSuppressionMissingFieldsStrategy.optional()
});
exports.AlertSuppressionCamel = AlertSuppressionCamel;