"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypeSpecificResponse = exports.TypeSpecificPatchProps = exports.TypeSpecificCreateProps = exports.ThresholdRuleUpdateProps = exports.ThresholdRuleResponseFields = exports.ThresholdRuleRequiredFields = exports.ThresholdRulePatchProps = exports.ThresholdRulePatchFields = exports.ThresholdRuleOptionalFields = exports.ThresholdRuleDefaultableFields = exports.ThresholdRuleCreateProps = exports.ThresholdRuleCreateFields = exports.ThresholdRule = exports.ThreatMatchRuleUpdateProps = exports.ThreatMatchRuleResponseFields = exports.ThreatMatchRuleRequiredFields = exports.ThreatMatchRulePatchProps = exports.ThreatMatchRulePatchFields = exports.ThreatMatchRuleOptionalFields = exports.ThreatMatchRuleDefaultableFields = exports.ThreatMatchRuleCreateProps = exports.ThreatMatchRuleCreateFields = exports.ThreatMatchRule = exports.SharedUpdateProps = exports.SharedResponseProps = exports.SharedPatchProps = exports.SharedCreateProps = exports.SavedQueryRuleUpdateProps = exports.SavedQueryRuleResponseFields = exports.SavedQueryRuleRequiredFields = exports.SavedQueryRulePatchProps = exports.SavedQueryRulePatchFields = exports.SavedQueryRuleOptionalFields = exports.SavedQueryRuleDefaultableFields = exports.SavedQueryRuleCreateProps = exports.SavedQueryRuleCreateFields = exports.SavedQueryRule = exports.RuleUpdateProps = exports.RuleResponse = exports.RulePatchProps = exports.RuleCreateProps = exports.ResponseFields = exports.QueryRuleUpdateProps = exports.QueryRuleResponseFields = exports.QueryRuleRequiredFields = exports.QueryRulePatchProps = exports.QueryRulePatchFields = exports.QueryRuleOptionalFields = exports.QueryRuleDefaultableFields = exports.QueryRuleCreateProps = exports.QueryRuleCreateFields = exports.QueryRule = exports.NewTermsRuleUpdateProps = exports.NewTermsRuleResponseFields = exports.NewTermsRuleRequiredFields = exports.NewTermsRulePatchProps = exports.NewTermsRulePatchFields = exports.NewTermsRuleOptionalFields = exports.NewTermsRuleDefaultableFields = exports.NewTermsRuleCreateProps = exports.NewTermsRuleCreateFields = exports.NewTermsRule = exports.MachineLearningRuleUpdateProps = exports.MachineLearningRuleResponseFields = exports.MachineLearningRuleRequiredFields = exports.MachineLearningRulePatchProps = exports.MachineLearningRulePatchFields = exports.MachineLearningRuleCreateProps = exports.MachineLearningRuleCreateFields = exports.MachineLearningRule = exports.EsqlRuleUpdateProps = exports.EsqlRuleResponseFields = exports.EsqlRuleRequiredFields = exports.EsqlRulePatchProps = exports.EsqlRulePatchFields = exports.EsqlRuleCreateProps = exports.EsqlRuleCreateFields = exports.EsqlRule = exports.EsqlQueryLanguage = exports.EqlRuleUpdateProps = exports.EqlRuleResponseFields = exports.EqlRulePatchProps = exports.EqlRulePatchFields = exports.EqlRuleCreateProps = exports.EqlRuleCreateFields = exports.EqlRule = exports.EqlRequiredFields = exports.EqlQueryLanguage = exports.EqlOptionalFields = exports.BaseResponseProps = exports.BaseRequiredFields = exports.BasePatchProps = exports.BaseOptionalFields = exports.BaseDefaultableFields = exports.BaseCreateProps = void 0;
var _zod = require("zod");
var _common_attributes = require("./common_attributes.gen");
var _execution_summary = require("../../rule_monitoring/model/execution_summary.gen");
var _eql_attributes = require("./specific_attributes/eql_attributes.gen");
var _response_actions = require("../rule_response_actions/response_actions.gen");
var _query_attributes = require("./specific_attributes/query_attributes.gen");
var _threshold_attributes = require("./specific_attributes/threshold_attributes.gen");
var _threat_match_attributes = require("./specific_attributes/threat_match_attributes.gen");
var _ml_attributes = require("./specific_attributes/ml_attributes.gen");
var _new_terms_attributes = require("./specific_attributes/new_terms_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 */

const BaseRequiredFields = _zod.z.object({
  name: _common_attributes.RuleName,
  description: _common_attributes.RuleDescription,
  risk_score: _common_attributes.RiskScore,
  severity: _common_attributes.Severity
});
exports.BaseRequiredFields = BaseRequiredFields;
const BaseOptionalFields = _zod.z.object({
  rule_name_override: _common_attributes.RuleNameOverride.optional(),
  timestamp_override: _common_attributes.TimestampOverride.optional(),
  timestamp_override_fallback_disabled: _common_attributes.TimestampOverrideFallbackDisabled.optional(),
  timeline_id: _common_attributes.TimelineTemplateId.optional(),
  timeline_title: _common_attributes.TimelineTemplateTitle.optional(),
  outcome: _common_attributes.SavedObjectResolveOutcome.optional(),
  alias_target_id: _common_attributes.SavedObjectResolveAliasTargetId.optional(),
  alias_purpose: _common_attributes.SavedObjectResolveAliasPurpose.optional(),
  license: _common_attributes.RuleLicense.optional(),
  note: _common_attributes.InvestigationGuide.optional(),
  building_block_type: _common_attributes.BuildingBlockType.optional(),
  output_index: _common_attributes.AlertsIndex.optional(),
  namespace: _common_attributes.AlertsIndexNamespace.optional(),
  meta: _common_attributes.RuleMetadata.optional(),
  investigation_fields: _common_attributes.InvestigationFields.optional(),
  throttle: _common_attributes.RuleActionThrottle.optional()
});
exports.BaseOptionalFields = BaseOptionalFields;
const BaseDefaultableFields = _zod.z.object({
  version: _common_attributes.RuleVersion.optional(),
  tags: _common_attributes.RuleTagArray.optional(),
  enabled: _common_attributes.IsRuleEnabled.optional(),
  risk_score_mapping: _common_attributes.RiskScoreMapping.optional(),
  severity_mapping: _common_attributes.SeverityMapping.optional(),
  interval: _common_attributes.RuleInterval.optional(),
  from: _common_attributes.RuleIntervalFrom.optional(),
  to: _common_attributes.RuleIntervalTo.optional(),
  actions: _zod.z.array(_common_attributes.RuleAction).optional(),
  exceptions_list: _zod.z.array(_common_attributes.RuleExceptionList).optional(),
  author: _common_attributes.RuleAuthorArray.optional(),
  false_positives: _common_attributes.RuleFalsePositiveArray.optional(),
  references: _common_attributes.RuleReferenceArray.optional(),
  max_signals: _common_attributes.MaxSignals.optional(),
  threat: _common_attributes.ThreatArray.optional()
});
exports.BaseDefaultableFields = BaseDefaultableFields;
const BaseCreateProps = BaseRequiredFields.merge(BaseOptionalFields).merge(BaseDefaultableFields);
exports.BaseCreateProps = BaseCreateProps;
const BasePatchProps = BaseRequiredFields.partial().merge(BaseOptionalFields).merge(BaseDefaultableFields);
exports.BasePatchProps = BasePatchProps;
const BaseResponseProps = BaseRequiredFields.merge(BaseOptionalFields).merge(BaseDefaultableFields.required());
exports.BaseResponseProps = BaseResponseProps;
const ResponseFields = _zod.z.object({
  id: _common_attributes.RuleObjectId,
  rule_id: _common_attributes.RuleSignatureId,
  immutable: _common_attributes.IsRuleImmutable,
  updated_at: _zod.z.string().datetime(),
  updated_by: _zod.z.string(),
  created_at: _zod.z.string().datetime(),
  created_by: _zod.z.string(),
  revision: _zod.z.number().int().min(0),
  related_integrations: _common_attributes.RelatedIntegrationArray,
  required_fields: _common_attributes.RequiredFieldArray,
  setup: _common_attributes.SetupGuide,
  execution_summary: _execution_summary.RuleExecutionSummary.optional()
});
exports.ResponseFields = ResponseFields;
const SharedCreateProps = BaseCreateProps.merge(_zod.z.object({
  rule_id: _common_attributes.RuleSignatureId.optional()
}));
exports.SharedCreateProps = SharedCreateProps;
const SharedUpdateProps = BaseCreateProps.merge(_zod.z.object({
  id: _common_attributes.RuleObjectId.optional(),
  rule_id: _common_attributes.RuleSignatureId.optional()
}));
exports.SharedUpdateProps = SharedUpdateProps;
const SharedPatchProps = BasePatchProps.merge(_zod.z.object({
  id: _common_attributes.RuleObjectId.optional(),
  rule_id: _common_attributes.RuleSignatureId.optional()
}));
exports.SharedPatchProps = SharedPatchProps;
const SharedResponseProps = BaseResponseProps.merge(ResponseFields);
exports.SharedResponseProps = SharedResponseProps;
const EqlQueryLanguage = _zod.z.literal('eql');
exports.EqlQueryLanguage = EqlQueryLanguage;
const EqlRequiredFields = _zod.z.object({
  /**
   * Rule type
   */
  type: _zod.z.literal('eql'),
  /**
   * EQL query to execute
   */
  query: _common_attributes.RuleQuery,
  /**
   * Query language to use
   */
  language: EqlQueryLanguage
});
exports.EqlRequiredFields = EqlRequiredFields;
const EqlOptionalFields = _zod.z.object({
  index: _common_attributes.IndexPatternArray.optional(),
  data_view_id: _common_attributes.DataViewId.optional(),
  filters: _common_attributes.RuleFilterArray.optional(),
  event_category_override: _eql_attributes.EventCategoryOverride.optional(),
  tiebreaker_field: _eql_attributes.TiebreakerField.optional(),
  timestamp_field: _eql_attributes.TimestampField.optional()
});
exports.EqlOptionalFields = EqlOptionalFields;
const EqlRuleCreateFields = EqlRequiredFields.merge(EqlOptionalFields);
exports.EqlRuleCreateFields = EqlRuleCreateFields;
const EqlRuleResponseFields = EqlRequiredFields.merge(EqlOptionalFields);
exports.EqlRuleResponseFields = EqlRuleResponseFields;
const EqlRulePatchFields = EqlRequiredFields.partial().merge(EqlOptionalFields);
exports.EqlRulePatchFields = EqlRulePatchFields;
const EqlRule = SharedResponseProps.merge(EqlRuleResponseFields);
exports.EqlRule = EqlRule;
const EqlRuleCreateProps = SharedCreateProps.merge(EqlRuleCreateFields);
exports.EqlRuleCreateProps = EqlRuleCreateProps;
const EqlRuleUpdateProps = SharedUpdateProps.merge(EqlRuleCreateFields);
exports.EqlRuleUpdateProps = EqlRuleUpdateProps;
const EqlRulePatchProps = SharedPatchProps.merge(EqlRulePatchFields);
exports.EqlRulePatchProps = EqlRulePatchProps;
const QueryRuleRequiredFields = _zod.z.object({
  /**
   * Rule type
   */
  type: _zod.z.literal('query')
});
exports.QueryRuleRequiredFields = QueryRuleRequiredFields;
const QueryRuleOptionalFields = _zod.z.object({
  index: _common_attributes.IndexPatternArray.optional(),
  data_view_id: _common_attributes.DataViewId.optional(),
  filters: _common_attributes.RuleFilterArray.optional(),
  saved_id: _common_attributes.SavedQueryId.optional(),
  response_actions: _zod.z.array(_response_actions.ResponseAction).optional(),
  alert_suppression: _query_attributes.AlertSuppression.optional()
});
exports.QueryRuleOptionalFields = QueryRuleOptionalFields;
const QueryRuleDefaultableFields = _zod.z.object({
  query: _common_attributes.RuleQuery.optional(),
  language: _common_attributes.KqlQueryLanguage.optional()
});
exports.QueryRuleDefaultableFields = QueryRuleDefaultableFields;
const QueryRuleCreateFields = QueryRuleRequiredFields.merge(QueryRuleOptionalFields).merge(QueryRuleDefaultableFields);
exports.QueryRuleCreateFields = QueryRuleCreateFields;
const QueryRulePatchFields = QueryRuleRequiredFields.partial().merge(QueryRuleOptionalFields).merge(QueryRuleDefaultableFields);
exports.QueryRulePatchFields = QueryRulePatchFields;
const QueryRuleResponseFields = QueryRuleRequiredFields.merge(QueryRuleOptionalFields).merge(QueryRuleDefaultableFields.required());
exports.QueryRuleResponseFields = QueryRuleResponseFields;
const QueryRule = SharedResponseProps.merge(QueryRuleResponseFields);
exports.QueryRule = QueryRule;
const QueryRuleCreateProps = SharedCreateProps.merge(QueryRuleCreateFields);
exports.QueryRuleCreateProps = QueryRuleCreateProps;
const QueryRuleUpdateProps = SharedUpdateProps.merge(QueryRuleCreateFields);
exports.QueryRuleUpdateProps = QueryRuleUpdateProps;
const QueryRulePatchProps = SharedPatchProps.merge(QueryRulePatchFields);
exports.QueryRulePatchProps = QueryRulePatchProps;
const SavedQueryRuleRequiredFields = _zod.z.object({
  /**
   * Rule type
   */
  type: _zod.z.literal('saved_query'),
  saved_id: _common_attributes.SavedQueryId
});
exports.SavedQueryRuleRequiredFields = SavedQueryRuleRequiredFields;
const SavedQueryRuleOptionalFields = _zod.z.object({
  index: _common_attributes.IndexPatternArray.optional(),
  data_view_id: _common_attributes.DataViewId.optional(),
  filters: _common_attributes.RuleFilterArray.optional(),
  response_actions: _zod.z.array(_response_actions.ResponseAction).optional(),
  alert_suppression: _query_attributes.AlertSuppression.optional(),
  query: _common_attributes.RuleQuery.optional()
});
exports.SavedQueryRuleOptionalFields = SavedQueryRuleOptionalFields;
const SavedQueryRuleDefaultableFields = _zod.z.object({
  language: _common_attributes.KqlQueryLanguage.optional()
});
exports.SavedQueryRuleDefaultableFields = SavedQueryRuleDefaultableFields;
const SavedQueryRuleCreateFields = SavedQueryRuleRequiredFields.merge(SavedQueryRuleOptionalFields).merge(SavedQueryRuleDefaultableFields);
exports.SavedQueryRuleCreateFields = SavedQueryRuleCreateFields;
const SavedQueryRulePatchFields = SavedQueryRuleRequiredFields.partial().merge(SavedQueryRuleOptionalFields).merge(SavedQueryRuleDefaultableFields);
exports.SavedQueryRulePatchFields = SavedQueryRulePatchFields;
const SavedQueryRuleResponseFields = SavedQueryRuleRequiredFields.merge(SavedQueryRuleOptionalFields).merge(SavedQueryRuleDefaultableFields.required());
exports.SavedQueryRuleResponseFields = SavedQueryRuleResponseFields;
const SavedQueryRule = SharedResponseProps.merge(SavedQueryRuleResponseFields);
exports.SavedQueryRule = SavedQueryRule;
const SavedQueryRuleCreateProps = SharedCreateProps.merge(SavedQueryRuleCreateFields);
exports.SavedQueryRuleCreateProps = SavedQueryRuleCreateProps;
const SavedQueryRuleUpdateProps = SharedUpdateProps.merge(SavedQueryRuleCreateFields);
exports.SavedQueryRuleUpdateProps = SavedQueryRuleUpdateProps;
const SavedQueryRulePatchProps = SharedPatchProps.merge(SavedQueryRulePatchFields);
exports.SavedQueryRulePatchProps = SavedQueryRulePatchProps;
const ThresholdRuleRequiredFields = _zod.z.object({
  /**
   * Rule type
   */
  type: _zod.z.literal('threshold'),
  query: _common_attributes.RuleQuery,
  threshold: _threshold_attributes.Threshold
});
exports.ThresholdRuleRequiredFields = ThresholdRuleRequiredFields;
const ThresholdRuleOptionalFields = _zod.z.object({
  index: _common_attributes.IndexPatternArray.optional(),
  data_view_id: _common_attributes.DataViewId.optional(),
  filters: _common_attributes.RuleFilterArray.optional(),
  saved_id: _common_attributes.SavedQueryId.optional(),
  alert_suppression: _threshold_attributes.ThresholdAlertSuppression.optional()
});
exports.ThresholdRuleOptionalFields = ThresholdRuleOptionalFields;
const ThresholdRuleDefaultableFields = _zod.z.object({
  language: _common_attributes.KqlQueryLanguage.optional()
});
exports.ThresholdRuleDefaultableFields = ThresholdRuleDefaultableFields;
const ThresholdRuleCreateFields = ThresholdRuleRequiredFields.merge(ThresholdRuleOptionalFields).merge(ThresholdRuleDefaultableFields);
exports.ThresholdRuleCreateFields = ThresholdRuleCreateFields;
const ThresholdRulePatchFields = ThresholdRuleRequiredFields.partial().merge(ThresholdRuleOptionalFields).merge(ThresholdRuleDefaultableFields);
exports.ThresholdRulePatchFields = ThresholdRulePatchFields;
const ThresholdRuleResponseFields = ThresholdRuleRequiredFields.merge(ThresholdRuleOptionalFields).merge(ThresholdRuleDefaultableFields.required());
exports.ThresholdRuleResponseFields = ThresholdRuleResponseFields;
const ThresholdRule = SharedResponseProps.merge(ThresholdRuleResponseFields);
exports.ThresholdRule = ThresholdRule;
const ThresholdRuleCreateProps = SharedCreateProps.merge(ThresholdRuleCreateFields);
exports.ThresholdRuleCreateProps = ThresholdRuleCreateProps;
const ThresholdRuleUpdateProps = SharedUpdateProps.merge(ThresholdRuleCreateFields);
exports.ThresholdRuleUpdateProps = ThresholdRuleUpdateProps;
const ThresholdRulePatchProps = SharedPatchProps.merge(ThresholdRulePatchFields);
exports.ThresholdRulePatchProps = ThresholdRulePatchProps;
const ThreatMatchRuleRequiredFields = _zod.z.object({
  /**
   * Rule type
   */
  type: _zod.z.literal('threat_match'),
  query: _common_attributes.RuleQuery,
  threat_query: _threat_match_attributes.ThreatQuery,
  threat_mapping: _threat_match_attributes.ThreatMapping,
  threat_index: _threat_match_attributes.ThreatIndex
});
exports.ThreatMatchRuleRequiredFields = ThreatMatchRuleRequiredFields;
const ThreatMatchRuleOptionalFields = _zod.z.object({
  index: _common_attributes.IndexPatternArray.optional(),
  data_view_id: _common_attributes.DataViewId.optional(),
  filters: _common_attributes.RuleFilterArray.optional(),
  saved_id: _common_attributes.SavedQueryId.optional(),
  threat_filters: _threat_match_attributes.ThreatFilters.optional(),
  threat_indicator_path: _threat_match_attributes.ThreatIndicatorPath.optional(),
  threat_language: _common_attributes.KqlQueryLanguage.optional(),
  concurrent_searches: _threat_match_attributes.ConcurrentSearches.optional(),
  items_per_search: _threat_match_attributes.ItemsPerSearch.optional()
});
exports.ThreatMatchRuleOptionalFields = ThreatMatchRuleOptionalFields;
const ThreatMatchRuleDefaultableFields = _zod.z.object({
  language: _common_attributes.KqlQueryLanguage.optional()
});
exports.ThreatMatchRuleDefaultableFields = ThreatMatchRuleDefaultableFields;
const ThreatMatchRuleCreateFields = ThreatMatchRuleRequiredFields.merge(ThreatMatchRuleOptionalFields).merge(ThreatMatchRuleDefaultableFields);
exports.ThreatMatchRuleCreateFields = ThreatMatchRuleCreateFields;
const ThreatMatchRulePatchFields = ThreatMatchRuleRequiredFields.partial().merge(ThreatMatchRuleOptionalFields).merge(ThreatMatchRuleDefaultableFields);
exports.ThreatMatchRulePatchFields = ThreatMatchRulePatchFields;
const ThreatMatchRuleResponseFields = ThreatMatchRuleRequiredFields.merge(ThreatMatchRuleOptionalFields).merge(ThreatMatchRuleDefaultableFields.required());
exports.ThreatMatchRuleResponseFields = ThreatMatchRuleResponseFields;
const ThreatMatchRule = SharedResponseProps.merge(ThreatMatchRuleResponseFields);
exports.ThreatMatchRule = ThreatMatchRule;
const ThreatMatchRuleCreateProps = SharedCreateProps.merge(ThreatMatchRuleCreateFields);
exports.ThreatMatchRuleCreateProps = ThreatMatchRuleCreateProps;
const ThreatMatchRuleUpdateProps = SharedUpdateProps.merge(ThreatMatchRuleCreateFields);
exports.ThreatMatchRuleUpdateProps = ThreatMatchRuleUpdateProps;
const ThreatMatchRulePatchProps = SharedPatchProps.merge(ThreatMatchRulePatchFields);
exports.ThreatMatchRulePatchProps = ThreatMatchRulePatchProps;
const MachineLearningRuleRequiredFields = _zod.z.object({
  /**
   * Rule type
   */
  type: _zod.z.literal('machine_learning'),
  anomaly_threshold: _ml_attributes.AnomalyThreshold,
  machine_learning_job_id: _ml_attributes.MachineLearningJobId
});
exports.MachineLearningRuleRequiredFields = MachineLearningRuleRequiredFields;
const MachineLearningRulePatchFields = MachineLearningRuleRequiredFields.partial();
exports.MachineLearningRulePatchFields = MachineLearningRulePatchFields;
const MachineLearningRuleResponseFields = MachineLearningRuleRequiredFields;
exports.MachineLearningRuleResponseFields = MachineLearningRuleResponseFields;
const MachineLearningRuleCreateFields = MachineLearningRuleRequiredFields;
exports.MachineLearningRuleCreateFields = MachineLearningRuleCreateFields;
const MachineLearningRule = SharedResponseProps.merge(MachineLearningRuleResponseFields);
exports.MachineLearningRule = MachineLearningRule;
const MachineLearningRuleCreateProps = SharedCreateProps.merge(MachineLearningRuleCreateFields);
exports.MachineLearningRuleCreateProps = MachineLearningRuleCreateProps;
const MachineLearningRuleUpdateProps = SharedUpdateProps.merge(MachineLearningRuleCreateFields);
exports.MachineLearningRuleUpdateProps = MachineLearningRuleUpdateProps;
const MachineLearningRulePatchProps = SharedPatchProps.merge(MachineLearningRulePatchFields);
exports.MachineLearningRulePatchProps = MachineLearningRulePatchProps;
const NewTermsRuleRequiredFields = _zod.z.object({
  /**
   * Rule type
   */
  type: _zod.z.literal('new_terms'),
  query: _common_attributes.RuleQuery,
  new_terms_fields: _new_terms_attributes.NewTermsFields,
  history_window_start: _new_terms_attributes.HistoryWindowStart
});
exports.NewTermsRuleRequiredFields = NewTermsRuleRequiredFields;
const NewTermsRuleOptionalFields = _zod.z.object({
  index: _common_attributes.IndexPatternArray.optional(),
  data_view_id: _common_attributes.DataViewId.optional(),
  filters: _common_attributes.RuleFilterArray.optional()
});
exports.NewTermsRuleOptionalFields = NewTermsRuleOptionalFields;
const NewTermsRuleDefaultableFields = _zod.z.object({
  language: _common_attributes.KqlQueryLanguage.optional()
});
exports.NewTermsRuleDefaultableFields = NewTermsRuleDefaultableFields;
const NewTermsRulePatchFields = NewTermsRuleRequiredFields.partial().merge(NewTermsRuleOptionalFields).merge(NewTermsRuleDefaultableFields);
exports.NewTermsRulePatchFields = NewTermsRulePatchFields;
const NewTermsRuleResponseFields = NewTermsRuleRequiredFields.merge(NewTermsRuleOptionalFields).merge(NewTermsRuleDefaultableFields.required());
exports.NewTermsRuleResponseFields = NewTermsRuleResponseFields;
const NewTermsRuleCreateFields = NewTermsRuleRequiredFields.merge(NewTermsRuleOptionalFields).merge(NewTermsRuleDefaultableFields);
exports.NewTermsRuleCreateFields = NewTermsRuleCreateFields;
const NewTermsRule = SharedResponseProps.merge(NewTermsRuleResponseFields);
exports.NewTermsRule = NewTermsRule;
const NewTermsRuleCreateProps = SharedCreateProps.merge(NewTermsRuleCreateFields);
exports.NewTermsRuleCreateProps = NewTermsRuleCreateProps;
const NewTermsRuleUpdateProps = SharedUpdateProps.merge(NewTermsRuleCreateFields);
exports.NewTermsRuleUpdateProps = NewTermsRuleUpdateProps;
const NewTermsRulePatchProps = SharedPatchProps.merge(NewTermsRulePatchFields);
exports.NewTermsRulePatchProps = NewTermsRulePatchProps;
const EsqlQueryLanguage = _zod.z.literal('esql');
exports.EsqlQueryLanguage = EsqlQueryLanguage;
const EsqlRuleRequiredFields = _zod.z.object({
  /**
   * Rule type
   */
  type: _zod.z.literal('esql'),
  language: EsqlQueryLanguage,
  /**
   * ESQL query to execute
   */
  query: _common_attributes.RuleQuery
});
exports.EsqlRuleRequiredFields = EsqlRuleRequiredFields;
const EsqlRulePatchFields = EsqlRuleRequiredFields.partial();
exports.EsqlRulePatchFields = EsqlRulePatchFields;
const EsqlRuleResponseFields = EsqlRuleRequiredFields;
exports.EsqlRuleResponseFields = EsqlRuleResponseFields;
const EsqlRuleCreateFields = EsqlRuleRequiredFields;
exports.EsqlRuleCreateFields = EsqlRuleCreateFields;
const EsqlRule = SharedResponseProps.merge(EsqlRuleResponseFields);
exports.EsqlRule = EsqlRule;
const EsqlRuleCreateProps = SharedCreateProps.merge(EsqlRuleCreateFields);
exports.EsqlRuleCreateProps = EsqlRuleCreateProps;
const EsqlRuleUpdateProps = SharedUpdateProps.merge(EsqlRuleCreateFields);
exports.EsqlRuleUpdateProps = EsqlRuleUpdateProps;
const EsqlRulePatchProps = SharedPatchProps.merge(EsqlRulePatchFields.partial());
exports.EsqlRulePatchProps = EsqlRulePatchProps;
const TypeSpecificCreateProps = _zod.z.discriminatedUnion('type', [EqlRuleCreateFields, QueryRuleCreateFields, SavedQueryRuleCreateFields, ThresholdRuleCreateFields, ThreatMatchRuleCreateFields, MachineLearningRuleCreateFields, NewTermsRuleCreateFields, EsqlRuleCreateFields]);
exports.TypeSpecificCreateProps = TypeSpecificCreateProps;
const TypeSpecificPatchProps = _zod.z.union([EqlRulePatchFields, QueryRulePatchFields, SavedQueryRulePatchFields, ThresholdRulePatchFields, ThreatMatchRulePatchFields, MachineLearningRulePatchFields, NewTermsRulePatchFields, EsqlRulePatchFields]);
exports.TypeSpecificPatchProps = TypeSpecificPatchProps;
const TypeSpecificResponse = _zod.z.discriminatedUnion('type', [EqlRuleResponseFields, QueryRuleResponseFields, SavedQueryRuleResponseFields, ThresholdRuleResponseFields, ThreatMatchRuleResponseFields, MachineLearningRuleResponseFields, NewTermsRuleResponseFields, EsqlRuleResponseFields]);
exports.TypeSpecificResponse = TypeSpecificResponse;
const RuleCreateProps = _zod.z.discriminatedUnion('type', [EqlRuleCreateProps, QueryRuleCreateProps, SavedQueryRuleCreateProps, ThresholdRuleCreateProps, ThreatMatchRuleCreateProps, MachineLearningRuleCreateProps, NewTermsRuleCreateProps, EsqlRuleCreateProps]);
exports.RuleCreateProps = RuleCreateProps;
const RuleUpdateProps = _zod.z.discriminatedUnion('type', [EqlRuleUpdateProps, QueryRuleUpdateProps, SavedQueryRuleUpdateProps, ThresholdRuleUpdateProps, ThreatMatchRuleUpdateProps, MachineLearningRuleUpdateProps, NewTermsRuleUpdateProps, EsqlRuleUpdateProps]);
exports.RuleUpdateProps = RuleUpdateProps;
const RulePatchProps = _zod.z.union([EqlRulePatchProps, QueryRulePatchProps, SavedQueryRulePatchProps, ThresholdRulePatchProps, ThreatMatchRulePatchProps, MachineLearningRulePatchProps, NewTermsRulePatchProps, EsqlRulePatchProps]);
exports.RulePatchProps = RulePatchProps;
const RuleResponse = _zod.z.discriminatedUnion('type', [EqlRule, QueryRule, SavedQueryRule, ThresholdRule, ThreatMatchRule, MachineLearningRule, NewTermsRule, EsqlRule]);
exports.RuleResponse = RuleResponse;