"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PerPage = exports.PaginationResult = exports.Page = void 0;
var _zod = require("zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 */

/**
 * Page number
 */

const Page = _zod.z.number().int().min(1);

/**
 * Number of items per page
 */
exports.Page = Page;
const PerPage = _zod.z.number().int().min(0);
exports.PerPage = PerPage;
const PaginationResult = _zod.z.object({
  page: Page,
  per_page: PerPage,
  /**
   * Total number of items
   */
  total: _zod.z.number().int().min(0)
});
exports.PaginationResult = PaginationResult;