"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetAlertAssigneesRequestBody = exports.AlertIds = exports.AlertAssignees = void 0;
var _zod = require("zod");
var _common_attributes = require("../model/rule_schema/common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 */

const AlertAssignees = _zod.z.object({
  /**
   * A list of users ids to assign.
   */
  add: _zod.z.array(_common_attributes.NonEmptyString),
  /**
   * A list of users ids to unassign.
   */
  remove: _zod.z.array(_common_attributes.NonEmptyString)
});

/**
 * A list of alerts ids.
 */
exports.AlertAssignees = AlertAssignees;
const AlertIds = _zod.z.array(_common_attributes.NonEmptyString).min(1);
exports.AlertIds = AlertIds;
const SetAlertAssigneesRequestBody = _zod.z.object({
  /**
   * Details about the assignees to assign and unassign.
   */
  assignees: AlertAssignees,
  /**
   * List of alerts ids to assign and unassign passed assignees.
   */
  ids: AlertIds
});
exports.SetAlertAssigneesRequestBody = SetAlertAssigneesRequestBody;