"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BetaBadge = exports.BETA = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BETA = _i18n.i18n.translate('securitySolutionPackages.beta.label', {
  defaultMessage: 'Beta'
});
exports.BETA = BETA;
const BetaBadge = ({
  text,
  className
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: text !== null && text !== void 0 ? text : BETA,
    size: "s",
    css: (0, _react2.css)`
        margin-left: ${euiTheme.size.s};
        color: ${euiTheme.colors.text};
        vertical-align: middle;
        margin-bottom: ${euiTheme.size.xxs};
      `,
    className: className
  });
};
exports.BetaBadge = BetaBadge;