"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesBaseKibanaFeature = void 0;
var _i18n = require("@kbn/i18n");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCasesBaseKibanaFeature = ({
  uiCapabilities,
  apiTags,
  savedObjects
}) => {
  return {
    id: _constants.CASES_FEATURE_ID,
    name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.linkSecuritySolutionCaseTitle', {
      defaultMessage: 'Cases'
    }),
    order: 1100,
    category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security,
    app: [_constants.CASES_FEATURE_ID, 'kibana'],
    catalogue: [_constants.APP_ID],
    cases: [_constants.APP_ID],
    privileges: {
      all: {
        api: apiTags.all,
        app: [_constants.CASES_FEATURE_ID, 'kibana'],
        catalogue: [_constants.APP_ID],
        cases: {
          create: [_constants.APP_ID],
          read: [_constants.APP_ID],
          update: [_constants.APP_ID]
        },
        savedObject: {
          all: [...savedObjects.files],
          read: [...savedObjects.files]
        },
        ui: uiCapabilities.all
      },
      read: {
        api: apiTags.read,
        app: [_constants.CASES_FEATURE_ID, 'kibana'],
        catalogue: [_constants.APP_ID],
        cases: {
          read: [_constants.APP_ID]
        },
        savedObject: {
          all: [],
          read: [...savedObjects.files]
        },
        ui: uiCapabilities.read
      }
    }
  };
};
exports.getCasesBaseKibanaFeature = getCasesBaseKibanaFeature;