"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppFeaturesPrivileges = exports.AppFeaturesPrivilegeId = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AppFeaturesPrivilegeId;
/**
 * This is the mapping of the privileges that are registered
 * using a different Kibana feature configuration (sub-feature, main feature privilege, etc)
 * in each offering type (ess, serverless)
 */
exports.AppFeaturesPrivilegeId = AppFeaturesPrivilegeId;
(function (AppFeaturesPrivilegeId) {
  AppFeaturesPrivilegeId["endpointExceptions"] = "endpoint_exceptions";
})(AppFeaturesPrivilegeId || (exports.AppFeaturesPrivilegeId = AppFeaturesPrivilegeId = {}));
const AppFeaturesPrivileges = {
  [AppFeaturesPrivilegeId.endpointExceptions]: {
    all: {
      ui: ['showEndpointExceptions', 'crudEndpointExceptions'],
      api: [`${_constants.APP_ID}-showEndpointExceptions`, `${_constants.APP_ID}-crudEndpointExceptions`]
    },
    read: {
      ui: ['showEndpointExceptions'],
      api: [`${_constants.APP_ID}-showEndpointExceptions`]
    }
  }
};
exports.AppFeaturesPrivileges = AppFeaturesPrivileges;