"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecurityAssistantAppFeaturesConfigurator = void 0;
var _config = require("@kbn/security-solution-features/config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSecurityAssistantAppFeaturesConfigurator = enabledAppFeatureKeys => () => {
  return (0, _config.createEnabledAppFeaturesConfigMap)(assistantAppFeaturesConfig, enabledAppFeatureKeys);
};

/**
 * Maps the AppFeatures keys to Kibana privileges that will be merged
 * into the base privileges config for the Security Assistant app.
 *
 * Privileges can be added in different ways:
 * - `privileges`: the privileges that will be added directly into the main Security Assistant feature.
 * - `subFeatureIds`: the ids of the sub-features that will be added into the Assistant subFeatures entry.
 * - `subFeaturesPrivileges`: the privileges that will be added into the existing Assistant subFeature with the privilege `id` specified.
 */
exports.getSecurityAssistantAppFeaturesConfigurator = getSecurityAssistantAppFeaturesConfigurator;
const assistantAppFeaturesConfig = {
  ..._config.assistantDefaultAppFeaturesConfig
  // ess-specific app features configs here
};