"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuritySolutionEssPlugin = void 0;
var _breadcrumbs = require("./breadcrumbs");
var _services = require("./common/services");
var _get_started = require("./get_started");
var _register_upsellings = require("./upselling/register_upsellings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SecuritySolutionEssPlugin {
  setup(_core, _setupDeps) {
    return {};
  }
  start(core, startDeps) {
    const {
      securitySolution,
      licensing
    } = startDeps;
    const services = (0, _services.createServices)(core, startDeps);
    licensing.license$.subscribe(license => {
      (0, _register_upsellings.registerUpsellings)(securitySolution.getUpselling(), license, services);
    });
    securitySolution.setComponents({
      GetStarted: (0, _get_started.getSecurityGetStartedComponent)(services)
    });
    (0, _breadcrumbs.subscribeBreadcrumbs)(services);
    return {};
  }
  stop() {}
}
exports.SecuritySolutionEssPlugin = SecuritySolutionEssPlugin;