"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResetSessionPage = ResetSessionPage;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _prompt_page = require("../prompt_page");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Static error page (rendered server-side) when user does not have permission to access the requested page.
 *
 * To trigger this error create a user without any roles and try to login.
 */
function ResetSessionPage({
  logoutUrl,
  buildNumber,
  basePath,
  customBranding
}) {
  return /*#__PURE__*/_react.default.createElement(_prompt_page.PromptPage, {
    buildNumber: buildNumber,
    basePath: basePath,
    scriptPaths: ['/internal/security/reset_session_page.js'],
    title: _i18n.i18n.translate('xpack.security.resetSession.title', {
      defaultMessage: 'You do not have permission to access the requested page'
    }),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.resetSession.description",
      defaultMessage: "Either go back to the previous page or log in as a different user."
    })),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      href: logoutUrl,
      "data-test-subj": "ResetSessionButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.resetSession.logOutButtonLabel",
      defaultMessage: "Log in as different user"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      id: "goBackButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.resetSession.goBackButtonLabel",
      defaultMessage: "Go back"
    }))],
    customBranding: customBranding
  });
}