"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmEnableUsers = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmEnableUsers = ({
  usernames,
  onCancel,
  onSuccess
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const [state, enableUsers] = (0, _useAsyncFn.default)(async () => {
    for (const username of usernames) {
      try {
        await new _.UserAPIClient(services.http).enableUser(username);
        services.notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.security.management.users.confirmEnableUsers.successMessage', {
          defaultMessage: "Activated user '{username}'",
          values: {
            username
          }
        }));
        onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
      } catch (error) {
        var _body;
        services.notifications.toasts.addDanger({
          title: _i18n.i18n.translate('xpack.security.management.users.confirmEnableUsers.errorMessage', {
            defaultMessage: "Could not activate user '{username}'",
            values: {
              username
            }
          }),
          text: ((_body = error.body) === null || _body === void 0 ? void 0 : _body.message) || error.message
        });
      }
    }
  }, [services.http]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    role: "dialog",
    title: _i18n.i18n.translate('xpack.security.management.users.confirmEnableUsers.title', {
      defaultMessage: "Activate {count, plural, one{user '{username}'} other{{count} users}}?",
      values: {
        count: usernames.length,
        username: usernames[0]
      }
    }),
    onCancel: onCancel,
    onConfirm: enableUsers,
    cancelButtonText: _i18n.i18n.translate('xpack.security.management.users.confirmEnableUsers.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.security.management.users.confirmEnableUsers.confirmButton', {
      defaultMessage: '{isLoading, select, true{Activating {count, plural, one{user} other{users}}…} other{Activate {count, plural, one{user} other{users}}}}',
      values: {
        count: usernames.length,
        isLoading: state.loading
      }
    }),
    isLoading: state.loading
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.users.confirmEnableUsers.description",
    defaultMessage: "{count, plural, one{This user} other{These users}} will be able to access Elastic{count, plural, one{.} other{:}}",
    values: {
      count: usernames.length
    }
  })), usernames.length > 1 && /*#__PURE__*/_react.default.createElement("ul", null, usernames.map(username => /*#__PURE__*/_react.default.createElement("li", {
    key: username
  }, username)))));
};
exports.ConfirmEnableUsers = ConfirmEnableUsers;