"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RolesGridPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _confirm_delete = require("./confirm_delete");
var _permission_denied = require("./permission_denied");
var _model = require("../../../../common/model");
var _badges = require("../../badges");
var _table_utils = require("../../table_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRoleManagementHref = (action, roleName) => {
  return `/${action}${roleName ? `/${encodeURIComponent(roleName)}` : ''}`;
};
class RolesGridPage extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "tableRef", void 0);
    (0, _defineProperty2.default)(this, "getPageContent", () => {
      const {
        roles
      } = this.state;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
        bottomBorder: true,
        pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.roles.roleTitle",
          defaultMessage: "Roles"
        }),
        description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.roles.subtitle",
          defaultMessage: "Apply roles to groups of users and manage permissions across the stack."
        }),
        rightSideItems: this.props.readOnly ? undefined : [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
          "data-test-subj": "createRoleButton"
        }, (0, _public.reactRouterNavigate)(this.props.history, getRoleManagementHref('edit')), {
          fill: true,
          iconType: "plusInCircleFilled"
        }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.roles.createRoleButtonLabel",
          defaultMessage: "Create role"
        }))]
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      }), this.state.showDeleteConfirmation ? /*#__PURE__*/_react.default.createElement(_confirm_delete.ConfirmDelete, {
        onCancel: this.onCancelDelete,
        rolesToDelete: this.state.selection.map(role => role.name),
        callback: this.handleDelete,
        notifications: this.props.notifications,
        rolesAPIClient: this.props.rolesAPIClient
      }) : null, /*#__PURE__*/_react.default.createElement(_table_utils.ActionsEuiTableFormatting, null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
        itemId: "name",
        responsive: false,
        columns: this.getColumnConfig(),
        hasActions: true,
        selection: this.props.readOnly ? undefined : {
          selectable: role => !role.metadata || !role.metadata._reserved,
          selectableMessage: selectable => !selectable ? 'Role is reserved' : '',
          onSelectionChange: selection => this.setState({
            selection
          })
        },
        pagination: {
          initialPageSize: 20,
          pageSizeOptions: [10, 20, 30, 50, 100]
        },
        items: this.state.visibleRoles,
        loading: roles.length === 0,
        search: {
          toolsLeft: this.renderToolsLeft(),
          toolsRight: this.renderToolsRight(),
          box: {
            incremental: true,
            'data-test-subj': 'searchRoles'
          },
          onChange: query => {
            this.setState({
              filter: query.queryText,
              visibleRoles: this.getVisibleRoles(this.state.roles, query.queryText, this.state.includeReservedRoles)
            });
          }
        },
        sorting: {
          sort: {
            field: 'name',
            direction: 'asc'
          }
        },
        ref: this.tableRef,
        rowProps: role => {
          return {
            'data-test-subj': `roleRow`
          };
        },
        isSelectable: true
      })));
    });
    (0, _defineProperty2.default)(this, "getColumnConfig", () => {
      const config = [{
        field: 'name',
        name: _i18n.i18n.translate('xpack.security.management.roles.nameColumnName', {
          defaultMessage: 'Role'
        }),
        sortable: true,
        render: (name, record) => {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            color: "subdued",
            size: "s"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
            "data-test-subj": "roleRowName"
          }, (0, _public.reactRouterNavigate)(this.props.history, getRoleManagementHref('edit', name))), name));
        }
      }, {
        field: 'metadata',
        name: _i18n.i18n.translate('xpack.security.management.roles.statusColumnName', {
          defaultMessage: 'Status'
        }),
        sortable: role => (0, _model.isRoleEnabled)(role) && !(0, _model.isRoleDeprecated)(role),
        render: (metadata, record) => {
          return this.getRoleStatusBadges(record);
        }
      }];
      if (!this.props.readOnly) {
        config.push({
          name: _i18n.i18n.translate('xpack.security.management.roles.actionsColumnName', {
            defaultMessage: 'Actions'
          }),
          width: '150px',
          actions: [{
            available: role => !(0, _model.isRoleReserved)(role),
            isPrimary: true,
            render: role => {
              const title = _i18n.i18n.translate('xpack.security.management.roles.cloneRoleActionName', {
                defaultMessage: `Clone`
              });
              const label = _i18n.i18n.translate('xpack.security.management.roles.cloneRoleActionLabel', {
                defaultMessage: `Clone {roleName}`,
                values: {
                  roleName: role.name
                }
              });
              return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
                content: title
              }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
                "aria-label": label,
                color: 'primary',
                "data-test-subj": `clone-role-action-${role.name}`,
                disabled: this.state.selection.length >= 1,
                iconType: 'copy'
              }, (0, _public.reactRouterNavigate)(this.props.history, getRoleManagementHref('clone', role.name))), title));
            }
          }, {
            available: role => !role.metadata || !role.metadata._reserved,
            render: role => {
              const title = _i18n.i18n.translate('xpack.security.management.roles.deleteRoleActionName', {
                defaultMessage: `Delete`
              });
              const label = _i18n.i18n.translate('xpack.security.management.roles.deleteRoleActionLabel', {
                defaultMessage: `Delete {roleName}`,
                values: {
                  roleName: role.name
                }
              });
              return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
                content: title
              }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
                "aria-label": label,
                color: 'danger',
                "data-test-subj": `delete-role-action-${role.name}`,
                disabled: this.state.selection.length >= 1,
                iconType: 'trash',
                onClick: () => this.deleteOneRole(role)
              }, title));
            }
          }, {
            available: role => !(0, _model.isRoleReadOnly)(role),
            enabled: () => this.state.selection.length === 0,
            isPrimary: true,
            render: role => {
              const title = _i18n.i18n.translate('xpack.security.management.roles.editRoleActionName', {
                defaultMessage: `Edit`
              });
              const label = _i18n.i18n.translate('xpack.security.management.roles.editRoleActionLabel', {
                defaultMessage: `Edit {roleName}`,
                values: {
                  roleName: role.name
                }
              });
              return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
                content: title
              }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
                "aria-label": label,
                color: 'primary',
                "data-test-subj": `edit-role-action-${role.name}`,
                disabled: this.state.selection.length >= 1,
                iconType: 'pencil'
              }, (0, _public.reactRouterNavigate)(this.props.history, getRoleManagementHref('edit', role.name))), title));
            }
          }]
        });
      }
      return config;
    });
    (0, _defineProperty2.default)(this, "getVisibleRoles", (roles, filter, includeReservedRoles) => {
      return roles.filter(role => {
        const normalized = `${role.name}`.toLowerCase();
        const normalizedQuery = filter.toLowerCase();
        return normalized.indexOf(normalizedQuery) !== -1 && (includeReservedRoles || !(0, _model.isRoleReserved)(role));
      });
    });
    (0, _defineProperty2.default)(this, "onIncludeReservedRolesChange", e => {
      this.setState({
        includeReservedRoles: e.target.checked,
        visibleRoles: this.getVisibleRoles(this.state.roles, this.state.filter, e.target.checked)
      });
    });
    (0, _defineProperty2.default)(this, "getRoleStatusBadges", role => {
      const enabled = (0, _model.isRoleEnabled)(role);
      const deprecated = (0, _model.isRoleDeprecated)(role);
      const reserved = (0, _model.isRoleReserved)(role);
      const badges = [];
      if (!enabled) {
        badges.push( /*#__PURE__*/_react.default.createElement(_badges.DisabledBadge, {
          "data-test-subj": "roleDisabled"
        }));
      }
      if (reserved) {
        badges.push( /*#__PURE__*/_react.default.createElement(_badges.ReservedBadge, {
          "data-test-subj": "roleReserved",
          tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.management.roles.reservedRoleBadgeTooltip",
            defaultMessage: "Reserved roles are built-in and cannot be edited or removed."
          })
        }));
      }
      if (deprecated) {
        badges.push( /*#__PURE__*/_react.default.createElement(_badges.DeprecatedBadge, {
          "data-test-subj": "roleDeprecated",
          tooltipContent: (0, _model.getExtendedRoleDeprecationNotice)(role)
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s"
      }, badges.map((badge, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: index,
        grow: false
      }, badge)));
    });
    (0, _defineProperty2.default)(this, "handleDelete", () => {
      this.setState({
        selection: [],
        showDeleteConfirmation: false
      });
      this.loadRoles();
    });
    (0, _defineProperty2.default)(this, "deleteOneRole", roleToDelete => {
      this.setState({
        selection: [roleToDelete],
        showDeleteConfirmation: true
      });
    });
    (0, _defineProperty2.default)(this, "onCancelDelete", () => {
      var _this$tableRef$curren;
      this.setState({
        showDeleteConfirmation: false,
        selection: []
      });
      (_this$tableRef$curren = this.tableRef.current) === null || _this$tableRef$curren === void 0 ? void 0 : _this$tableRef$curren.setSelection([]);
    });
    this.state = {
      roles: [],
      visibleRoles: [],
      selection: [],
      filter: '',
      showDeleteConfirmation: false,
      permissionDenied: false,
      includeReservedRoles: true
    };
    this.tableRef = /*#__PURE__*/_react.default.createRef();
  }
  componentDidMount() {
    this.loadRoles();
  }
  render() {
    const {
      permissionDenied
    } = this.state;
    return permissionDenied ? /*#__PURE__*/_react.default.createElement(_permission_denied.PermissionDenied, null) : this.getPageContent();
  }
  async loadRoles() {
    try {
      const roles = await this.props.rolesAPIClient.getRoles();
      this.setState({
        roles,
        visibleRoles: this.getVisibleRoles(roles, this.state.filter, this.state.includeReservedRoles)
      });
    } catch (e) {
      if (_lodash.default.get(e, 'body.statusCode') === 403) {
        this.setState({
          permissionDenied: true
        });
      } else {
        this.props.notifications.toasts.addDanger(_i18n.i18n.translate('xpack.security.management.roles.fetchingRolesErrorMessage', {
          defaultMessage: 'Error fetching roles: {message}',
          values: {
            message: _lodash.default.get(e, 'body.message', '')
          }
        }));
      }
    }
  }
  renderToolsLeft() {
    const {
      selection
    } = this.state;
    if (selection.length === 0) {
      return;
    }
    const numSelected = selection.length;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "deleteRoleButton",
      color: "danger",
      onClick: () => this.setState({
        showDeleteConfirmation: true
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.deleteSelectedRolesButtonLabel",
      defaultMessage: "Delete {numSelected} role{numSelected, plural, one { } other {s}}",
      values: {
        numSelected
      }
    }));
  }
  renderToolsRight() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      "data-test-subj": "showReservedRolesSwitch",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.roles.showReservedRolesLabel",
        defaultMessage: "Show reserved roles"
      }),
      checked: this.state.includeReservedRoles,
      onChange: this.onIncludeReservedRolesChange
    });
  }
}
exports.RolesGridPage = RolesGridPage;
(0, _defineProperty2.default)(RolesGridPage, "defaultProps", {
  readOnly: false
});