"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuredFeature = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/features-plugin/common");
var _primary_feature_privilege = require("./primary_feature_privilege");
var _secured_sub_feature = require("./secured_sub_feature");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SecuredFeature extends _common.KibanaFeature {
  constructor(config, actionMapping = {}) {
    var _this$config$subFeatu, _this$config$subFeatu2;
    super(config);
    (0, _defineProperty2.default)(this, "primaryFeaturePrivileges", void 0);
    (0, _defineProperty2.default)(this, "minimalPrimaryFeaturePrivileges", void 0);
    (0, _defineProperty2.default)(this, "subFeaturePrivileges", void 0);
    (0, _defineProperty2.default)(this, "securedSubFeatures", void 0);
    this.primaryFeaturePrivileges = Object.entries(this.config.privileges || {}).map(([id, privilege]) => new _primary_feature_privilege.PrimaryFeaturePrivilege(id, privilege, actionMapping[id]));
    this.minimalPrimaryFeaturePrivileges = Object.entries(this.config.privileges || {}).map(([id, privilege]) => new _primary_feature_privilege.PrimaryFeaturePrivilege(`minimal_${id}`, privilege, actionMapping[`minimal_${id}`]));
    this.securedSubFeatures = (_this$config$subFeatu = (_this$config$subFeatu2 = this.config.subFeatures) === null || _this$config$subFeatu2 === void 0 ? void 0 : _this$config$subFeatu2.map(sf => new _secured_sub_feature.SecuredSubFeature(sf, actionMapping))) !== null && _this$config$subFeatu !== void 0 ? _this$config$subFeatu : [];
    this.subFeaturePrivileges = this.securedSubFeatures.reduce((acc, subFeature) => {
      return [...acc, ...subFeature.privilegeIterator()];
    }, []);
  }
  getPrivilegesTooltip() {
    return this.config.privilegesTooltip;
  }
  getAllPrivileges() {
    return [...this.primaryFeaturePrivileges, ...this.minimalPrimaryFeaturePrivileges, ...this.subFeaturePrivileges];
  }
  getPrimaryFeaturePrivileges({
    includeMinimalFeaturePrivileges
  } = {
    includeMinimalFeaturePrivileges: false
  }) {
    return includeMinimalFeaturePrivileges ? [this.primaryFeaturePrivileges, this.minimalPrimaryFeaturePrivileges].flat() : [...this.primaryFeaturePrivileges];
  }
  getMinimalFeaturePrivileges() {
    return [...this.minimalPrimaryFeaturePrivileges];
  }
  getSubFeaturePrivileges() {
    return [...this.subFeaturePrivileges];
  }
  getSubFeatures() {
    return [...this.securedSubFeatures];
  }
}
exports.SecuredFeature = SecuredFeature;