"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegeCollection = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PrivilegeCollection {
  constructor(privileges) {
    (0, _defineProperty2.default)(this, "actions", void 0);
    this.actions = new Set(privileges.reduce((acc, priv) => [...acc, ...priv.actions], []));
  }
  grantsPrivilege(privilege) {
    return this.checkActions(this.actions, privilege.actions).hasAllRequested;
  }
  checkActions(knownActions, candidateActions) {
    const missing = candidateActions.filter(action => !knownActions.has(action));
    const hasAllRequested = knownActions.size > 0 && candidateActions.length > 0 && missing.length === 0;
    return {
      missing,
      hasAllRequested
    };
  }
}
exports.PrivilegeCollection = PrivilegeCollection;