"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegeSpaceTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./privilege_space_table.scss");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/spaces-plugin/public");
var _privilege_display = require("./privilege_display");
var _model = require("../../../../../../../common/model");
var _privilege_utils = require("../../../privilege_utils");
var _constants = require("../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SPACES_DISPLAY_COUNT = 4;
class PrivilegeSpaceTable extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      expandedSpacesGroups: []
    });
    (0, _defineProperty2.default)(this, "renderKibanaPrivileges", () => {
      const {
        privilegeCalculator,
        displaySpaces
      } = this.props;
      const spacePrivileges = this.getSortedPrivileges();
      const rows = spacePrivileges.map((spacePrivs, privilegeIndex) => {
        const spaces = spacePrivs.spaces.map(spaceId => displaySpaces.find(space => space.id === spaceId) || {
          id: spaceId,
          name: spaceId,
          disabledFeatures: [],
          deleted: true
        });
        return {
          spaces,
          privilegeIndex,
          isGlobal: (0, _privilege_utils.isGlobalPrivilegeDefinition)(spacePrivs),
          privileges: {
            spaces: spacePrivs.spaces,
            base: spacePrivs.base || [],
            feature: spacePrivs.feature || {},
            reserved: spacePrivs._reserved || []
          }
        };
      });
      const getExtraBadgeProps = space => {
        if (space.deleted) {
          return {
            iconType: 'trash'
          };
        }
        return {};
      };
      const columns = [{
        field: 'spaces',
        name: 'Spaces',
        width: '60%',
        render: (spaces, record) => {
          const isExpanded = this.state.expandedSpacesGroups.includes(record.privilegeIndex);
          const displayedSpaces = isExpanded ? spaces : spaces.slice(0, SPACES_DISPLAY_COUNT);
          let button = null;
          if (spaces.length > displayedSpaces.length) {
            button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
              size: "xs",
              onClick: () => this.toggleExpandSpacesGroup(record.privilegeIndex)
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.security.management.editRole.spacePrivilegeTable.showNMoreSpacesLink",
              defaultMessage: "+{count} more",
              values: {
                count: spaces.length - displayedSpaces.length
              }
            }));
          } else if (isExpanded) {
            button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
              size: "xs",
              onClick: () => this.toggleExpandSpacesGroup(record.privilegeIndex)
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.security.management.editRole.spacePrivilegeTable.showLessSpacesLink",
              defaultMessage: "show less"
            }));
          }
          return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("span", {
            "data-test-subj": "spacesColumn"
          }, displayedSpaces.map(space => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
            key: space.id
          }, getExtraBadgeProps(space), {
            color: (0, _public.getSpaceColor)(space)
          }), space.name))), button);
        }
      }, {
        field: 'privileges',
        name: 'Privileges',
        render: (privileges, record) => {
          var _privilegeCalculator$, _privilegeCalculator$2;
          if (privileges.reserved.length > 0) {
            return /*#__PURE__*/_react.default.createElement(_privilege_display.PrivilegeDisplay, {
              privilege: privileges.reserved,
              "data-test-subj": `privilegeColumn`
            });
          }
          let icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "empty",
            size: "s"
          });
          if (privilegeCalculator.hasSupersededInheritedPrivileges(record.privilegeIndex)) {
            icon = /*#__PURE__*/_react.default.createElement("span", {
              "data-test-subj": "spaceTablePrivilegeSupersededWarning"
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
              type: "warning",
              size: "s",
              content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "xpack.security.management.editRole.spacePrivilegeTable.supersededPrivilegeWarning",
                defaultMessage: "Privileges are superseded by configured global privilege. View the privilege summary to see effective privileges."
              })
            }));
          }
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "xs",
            alignItems: "center"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, icon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_privilege_display.PrivilegeDisplay, {
            privilege: (_privilegeCalculator$ = (_privilegeCalculator$2 = privilegeCalculator.getBasePrivilege(record.privilegeIndex)) === null || _privilegeCalculator$2 === void 0 ? void 0 : _privilegeCalculator$2.id) !== null && _privilegeCalculator$ !== void 0 ? _privilegeCalculator$ : _constants.CUSTOM_PRIVILEGE_VALUE,
            "data-test-subj": `privilegeColumn`
          })));
        }
      }];
      if (!this.props.disabled) {
        columns.push({
          name: 'Actions',
          actions: [{
            render: record => {
              return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
                "aria-label": _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeTable.editPrivilegesLabel', {
                  defaultMessage: `Edit privileges for the following spaces: {spaceNames}.`,
                  values: {
                    spaceNames: record.spaces.map(s => s.name).join(', ')
                  }
                }),
                color: 'primary',
                iconType: 'pencil',
                onClick: () => this.props.onEdit(record.privilegeIndex)
              });
            }
          }, {
            render: record => {
              return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
                "aria-label": _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeTable.deletePrivilegesLabel', {
                  defaultMessage: `Delete privileges for the following spaces: {spaceNames}.`,
                  values: {
                    spaceNames: record.spaces.map(s => s.name).join(', ')
                  }
                }),
                color: 'danger',
                iconType: 'trash',
                onClick: () => this.onDeleteSpacePrivilege(record)
              });
            }
          }]
        });
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
        columns: columns,
        items: rows,
        hasActions: true,
        rowProps: item => {
          return {
            className: (0, _privilege_utils.isGlobalPrivilegeDefinition)(item.privileges) ? 'secPrivilegeTable__row--isGlobalSpace' : ''
          };
        }
      });
    });
    (0, _defineProperty2.default)(this, "getSortedPrivileges", () => {
      const spacePrivileges = this.props.role.kibana;
      return spacePrivileges.sort((priv1, priv2) => {
        return (0, _privilege_utils.isGlobalPrivilegeDefinition)(priv1) ? -1 : (0, _privilege_utils.isGlobalPrivilegeDefinition)(priv2) ? 1 : 0;
      });
    });
    (0, _defineProperty2.default)(this, "toggleExpandSpacesGroup", privilegeIndex => {
      if (this.state.expandedSpacesGroups.includes(privilegeIndex)) {
        this.setState({
          expandedSpacesGroups: this.state.expandedSpacesGroups.filter(i => i !== privilegeIndex)
        });
      } else {
        this.setState({
          expandedSpacesGroups: [...this.state.expandedSpacesGroups, privilegeIndex]
        });
      }
    });
    (0, _defineProperty2.default)(this, "onDeleteSpacePrivilege", item => {
      const roleCopy = (0, _model.copyRole)(this.props.role);
      roleCopy.kibana.splice(item.privilegeIndex, 1);
      this.props.onChange(roleCopy);
      this.setState({
        expandedSpacesGroups: this.state.expandedSpacesGroups.filter(i => i !== item.privilegeIndex)
      });
    });
  }
  render() {
    return this.renderKibanaPrivileges();
  }
}
exports.PrivilegeSpaceTable = PrivilegeSpaceTable;