"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditRolePage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/remote-clusters-plugin/public");
var _delete_role_button = require("./delete_role_button");
var _privileges = require("./privileges");
var _reserved_role_badge = require("./reserved_role_badge");
var _validate_role = require("./validate_role");
var _model = require("../../../../common/model");
var _use_capabilities = require("../../../components/use_capabilities");
var _model2 = require("../model");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useRemoteClusters(http) {
  return (0, _useAsync.default)(() => http.get(_public2.REMOTE_CLUSTERS_PATH));
}
function useFeatureCheck(http) {
  return (0, _useAsync.default)(() => http.get('/internal/security/_check_role_mapping_features'));
}
function useRunAsUsers(userAPIClient, fatalErrors) {
  const [userNames, setUserNames] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    userAPIClient.getUsers().then(users => setUserNames(users.map(user => user.username)), err => fatalErrors.add(err));
  }, [fatalErrors, userAPIClient]);
  return userNames;
}
function useIndexPatternsTitles(dataViews, fatalErrors, notifications) {
  const [indexPatternsTitles, setIndexPatternsTitles] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    dataViews.getTitles().catch(err => {
      var _err$response;
      // If user doesn't have access to the index patterns they still should be able to create new
      // or edit existing role.
      if (((_err$response = err.response) === null || _err$response === void 0 ? void 0 : _err$response.status) === 403) {
        notifications.toasts.addDanger({
          title: _i18n.i18n.translate('xpack.security.management.roles.noIndexPatternsPermission', {
            // Note: we are attempting to fetch data views (a Kibana construct), but we are using those to render a list of usable index
            // patterns (an Elasticsearch construct) for the user. This error message reflects what is shown on the UI.
            defaultMessage: 'You need permission to access the list of available index patterns.'
          })
        });
        return [];
      }
      fatalErrors.add(err);
    }).then(titles => setIndexPatternsTitles(titles.filter(Boolean)));
  }, [fatalErrors, dataViews, notifications]);
  return indexPatternsTitles;
}
function usePrivileges(privilegesAPIClient, fatalErrors) {
  const [privileges, setPrivileges] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    Promise.all([privilegesAPIClient.getAll({
      includeActions: true,
      respectLicenseLevel: false
    }), privilegesAPIClient.getBuiltIn()]).then(([kibanaPrivileges, builtInESPrivileges]) => setPrivileges([kibanaPrivileges, builtInESPrivileges]), err => fatalErrors.add(err));
  }, [privilegesAPIClient, fatalErrors]);
  return privileges;
}
function useRole(rolesAPIClient, fatalErrors, notifications, license, action, backToRoleList, roleName) {
  const [role, setRole] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    const rolePromise = roleName ? rolesAPIClient.getRole(roleName) : Promise.resolve({
      name: '',
      elasticsearch: {
        cluster: [],
        indices: [],
        run_as: []
      },
      kibana: [],
      _unrecognized_applications: []
    });
    rolePromise.then(fetchedRole => {
      if (action === 'clone' && (0, _model.isRoleReserved)(fetchedRole)) {
        backToRoleList();
        return;
      }
      const isEditingExistingRole = !!roleName && action === 'edit';
      if (!isEditingExistingRole && fetchedRole.elasticsearch.indices.length === 0) {
        const emptyOption = {
          names: [],
          privileges: []
        };
        const {
          allowRoleDocumentLevelSecurity,
          allowRoleFieldLevelSecurity
        } = license.getFeatures();
        if (allowRoleFieldLevelSecurity) {
          emptyOption.field_security = {
            grant: ['*'],
            except: []
          };
        }
        if (allowRoleDocumentLevelSecurity) {
          emptyOption.query = '';
        }
        fetchedRole.elasticsearch.indices.push(emptyOption);
      }
      setRole(action === 'clone' ? (0, _model.prepareRoleClone)(fetchedRole) : (0, _model.copyRole)(fetchedRole));
    }).catch(err => {
      var _err$response2;
      if (((_err$response2 = err.response) === null || _err$response2 === void 0 ? void 0 : _err$response2.status) === 404) {
        notifications.toasts.addDanger({
          title: _i18n.i18n.translate('xpack.security.management.roles.roleNotFound', {
            defaultMessage: 'No "{roleName}" role found.',
            values: {
              roleName
            }
          })
        });
        backToRoleList();
      } else {
        fatalErrors.add(err);
      }
    });
  }, [roleName, action, fatalErrors, rolesAPIClient, notifications, license, backToRoleList]);
  return [role, setRole];
}
function useSpaces(http, fatalErrors) {
  const [spaces, setSpaces] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    http.get('/api/spaces/space').then(fetchedSpaces => setSpaces({
      enabled: true,
      list: fetchedSpaces
    }), err => {
      var _err$response3;
      // Spaces plugin can be disabled and hence this endpoint can be unavailable.
      if (((_err$response3 = err.response) === null || _err$response3 === void 0 ? void 0 : _err$response3.status) === 404) {
        setSpaces({
          enabled: false,
          list: []
        });
      } else {
        fatalErrors.add(err);
      }
    });
  }, [http, fatalErrors]);
  return spaces;
}
function useFeatures(getFeatures, fatalErrors) {
  const [features, setFeatures] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    getFeatures().catch(err => {
      var _err$response4;
      // Currently, the `/api/features` endpoint effectively requires the "Global All" kibana privilege (e.g., what
      // the `kibana_user` grants), because it returns information about all registered features (#35841). It's
      // possible that a user with `manage_security` will attempt to visit the role management page without the
      // correct Kibana privileges. If that's the case, then they receive a partial view of the role, and the UI does
      // not allow them to make changes to that role's kibana privileges. When this user visits the edit role page,
      // this API endpoint will throw a 403, which causes view to fail completely. So we instead attempt to detect the
      // 403 here, and respond in a way that still allows the UI to render itself.
      const unauthorizedForFeatures = ((_err$response4 = err.response) === null || _err$response4 === void 0 ? void 0 : _err$response4.status) === 403;
      if (unauthorizedForFeatures) {
        return [];
      }
      fatalErrors.add(err);
    }).then(retrievedFeatures => {
      setFeatures(retrievedFeatures);
    });
  }, [fatalErrors, getFeatures]);
  return features;
}
const EditRolePage = ({
  userAPIClient,
  dataViews,
  rolesAPIClient,
  indicesAPIClient,
  privilegesAPIClient,
  getFeatures,
  http,
  roleName,
  action,
  fatalErrors,
  license,
  docLinks,
  uiCapabilities,
  notifications,
  history,
  spacesApiUi
}) => {
  if (!dataViews) {
    // The dataViews plugin is technically marked as an optional dependency because we don't need to pull it in for Anonymous pages (such
    // as the login page). That said, it _is_ required for this page to function correctly, so we throw an error here if it's not available.
    // We don't ever expect Kibana to work correctly if the dataViews plugin is not available (and we don't expect this to happen at all),
    // so this error edge case is an acceptable tradeoff.
    throw new Error('The dataViews plugin is required for this page, but it is not available');
  }
  const backToRoleList = (0, _react.useCallback)(() => history.push('/'), [history]);
  const hasReadOnlyPrivileges = !(0, _use_capabilities.useCapabilities)('roles').save;

  // We should keep the same mutable instance of Validator for every re-render since we'll
  // eventually enable validation after the first time user tries to save a role.
  const {
    current: validator
  } = (0, _react.useRef)(new _validate_role.RoleValidator({
    shouldValidate: false
  }));
  const [formError, setFormError] = (0, _react.useState)(null);
  const [creatingRoleAlreadyExists, setCreatingRoleAlreadyExists] = (0, _react.useState)(false);
  const [previousName, setPreviousName] = (0, _react.useState)('');
  const runAsUsers = useRunAsUsers(userAPIClient, fatalErrors);
  const indexPatternsTitles = useIndexPatternsTitles(dataViews, fatalErrors, notifications);
  const privileges = usePrivileges(privilegesAPIClient, fatalErrors);
  const spaces = useSpaces(http, fatalErrors);
  const features = useFeatures(getFeatures, fatalErrors);
  const featureCheckState = useFeatureCheck(http);
  const remoteClustersState = useRemoteClusters(http);
  const [role, setRole] = useRole(rolesAPIClient, fatalErrors, notifications, license, action, backToRoleList, roleName);
  const isEditingExistingRole = !!roleName && action === 'edit';
  (0, _react.useEffect)(() => {
    if (hasReadOnlyPrivileges && !isEditingExistingRole) {
      backToRoleList();
    }
  }, [hasReadOnlyPrivileges, isEditingExistingRole]); // eslint-disable-line react-hooks/exhaustive-deps

  if (!role || !runAsUsers || !indexPatternsTitles || !privileges || !spaces || !features || !featureCheckState.value) {
    return null;
  }
  const isRoleReadOnly = hasReadOnlyPrivileges || (0, _model.isRoleReadOnly)(role);
  const isRoleReserved = (0, _model.isRoleReserved)(role);
  const isDeprecatedRole = (0, _model.isRoleDeprecated)(role);
  const [kibanaPrivileges, builtInESPrivileges] = privileges;
  const getFormTitle = () => {
    let titleText;
    const props = {
      tabIndex: 0
    };
    if (isRoleReserved || isRoleReadOnly) {
      titleText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.viewingRoleTitle",
        defaultMessage: "Viewing role"
      });
      props['aria-describedby'] = 'reservedRoleDescription';
    } else if (isEditingExistingRole) {
      titleText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.editRoleTitle",
        defaultMessage: "Edit role"
      });
    } else {
      titleText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.createRoleTitle",
        defaultMessage: "Create role"
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "l"
    }, /*#__PURE__*/_react.default.createElement("h1", props, titleText, " ", /*#__PURE__*/_react.default.createElement(_reserved_role_badge.ReservedRoleBadge, {
      role: role
    })));
  };
  const getActionButton = () => {
    if (isEditingExistingRole && !isRoleReadOnly) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_delete_role_button.DeleteRoleButton, {
        canDelete: true,
        onDelete: handleDeleteRole
      }));
    }
    return null;
  };
  const getRoleName = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
      "data-test-subj": 'roleNameFormRow',
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.roleNameFormRowTitle",
        defaultMessage: "Role name"
      }),
      helpText: !isRoleReserved && isEditingExistingRole ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.roleNameFormRowHelpText",
        defaultMessage: "A role's name cannot be changed once it has been created."
      }) : undefined
    }, validator.validateRoleName(role), creatingRoleAlreadyExists ? {
      error: 'A role with this name already exists.',
      isInvalid: true
    } : {}), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      name: 'name',
      value: role.name || '',
      onChange: onNameChange,
      onBlur: onNameBlur,
      "data-test-subj": 'roleFormNameInput',
      disabled: isRoleReserved || isEditingExistingRole || isRoleReadOnly,
      isInvalid: creatingRoleAlreadyExists
    })));
  };
  const onNameChange = e => setRole({
    ...role,
    name: e.target.value
  });
  const onNameBlur = e => {
    if (!isEditingExistingRole && previousName !== role.name) {
      setPreviousName(role.name);
      doesRoleExist().then(roleExists => {
        setCreatingRoleAlreadyExists(roleExists);
      });
    }
  };
  const getElasticsearchPrivileges = () => {
    var _featureCheckState$va;
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_privileges.ElasticsearchPrivileges, {
      role: role,
      editable: !isRoleReadOnly,
      indicesAPIClient: indicesAPIClient,
      onChange: onRoleChange,
      runAsUsers: runAsUsers,
      validator: validator,
      indexPatterns: indexPatternsTitles,
      remoteClusters: remoteClustersState.value,
      builtinESPrivileges: builtInESPrivileges,
      license: license,
      docLinks: docLinks,
      canUseRemoteIndices: (_featureCheckState$va = featureCheckState.value) === null || _featureCheckState$va === void 0 ? void 0 : _featureCheckState$va.canUseRemoteIndices
    }));
  };
  const onRoleChange = newRole => setRole(newRole);
  const getKibanaPrivileges = () => {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_privileges.KibanaPrivilegesRegion, {
      kibanaPrivileges: new _model2.KibanaPrivileges(kibanaPrivileges, features),
      spaces: spaces.list,
      spacesEnabled: spaces.enabled,
      uiCapabilities: uiCapabilities,
      canCustomizeSubFeaturePrivileges: license.getFeatures().allowSubFeaturePrivileges,
      editable: !isRoleReadOnly,
      role: role,
      onChange: onRoleChange,
      validator: validator,
      spacesApiUi: spacesApiUi
    }));
  };
  const getFormButtons = () => {
    if (isRoleReadOnly) {
      return getReturnToRoleListButton();
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, getSaveButton()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, getCancelButton()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }), getActionButton());
  };
  const getReturnToRoleListButton = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, ''), {
      iconType: "arrowLeft",
      "data-test-subj": "roleFormReturnButton"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.returnToRoleListButtonLabel",
      defaultMessage: "Back to roles"
    }));
  };
  const getSaveButton = () => {
    const saveText = isEditingExistingRole ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.updateRoleText",
      defaultMessage: "Update role"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.createRoleText",
      defaultMessage: "Create role"
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": `roleFormSaveButton`,
      fill: true,
      onClick: saveRole,
      disabled: isRoleReserved || creatingRoleAlreadyExists
    }, saveText);
  };
  const getCancelButton = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": `roleFormCancelButton`,
      onClick: backToRoleList
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.cancelButtonLabel",
      defaultMessage: "Cancel"
    }));
  };
  const saveRole = async () => {
    validator.enableValidation();
    const result = validator.validateForSave(role);
    if (result.isInvalid) {
      setFormError(result);
    } else {
      setFormError(null);
      try {
        await rolesAPIClient.saveRole({
          role,
          createOnly: !isEditingExistingRole
        });
      } catch (error) {
        var _error$body, _error$body$message, _error$body2;
        if (!isEditingExistingRole && (error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.statusCode) === 409) {
          setCreatingRoleAlreadyExists(true);
          window.scroll({
            top: 0,
            behavior: 'smooth'
          });
          return;
        }
        notifications.toasts.addDanger((_error$body$message = error === null || error === void 0 ? void 0 : (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message) !== null && _error$body$message !== void 0 ? _error$body$message : _i18n.i18n.translate('xpack.security.management.editRole.errorSavingRoleError', {
          defaultMessage: 'Error saving role'
        }));
        return;
      }
      notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.security.management.editRole.roleSuccessfullySavedNotificationMessage', {
        defaultMessage: 'Saved role'
      }));
      backToRoleList();
    }
  };
  const doesRoleExist = async () => {
    try {
      await rolesAPIClient.getRole(role.name);
      return true;
    } catch (error) {
      return false;
    }
  };
  const handleDeleteRole = async () => {
    try {
      await rolesAPIClient.deleteRole(role.name);
    } catch (error) {
      var _error$data$message, _error$data;
      notifications.toasts.addDanger((_error$data$message = error === null || error === void 0 ? void 0 : (_error$data = error.data) === null || _error$data === void 0 ? void 0 : _error$data.message) !== null && _error$data$message !== void 0 ? _error$data$message : _i18n.i18n.translate('xpack.security.management.editRole.errorDeletingRoleError', {
        defaultMessage: 'Error deleting role'
      }));
      return;
    }
    notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.security.management.editRole.roleSuccessfullyDeletedNotificationMessage', {
      defaultMessage: 'Deleted role'
    }));
    backToRoleList();
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "editRolePage"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, formError, getFormTitle(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRole.setPrivilegesToKibanaSpacesDescription",
    defaultMessage: "Set privileges on your Elasticsearch data and control access to your Kibana spaces."
  })), isRoleReserved && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", {
    id: "reservedRoleDescription",
    tabIndex: 0
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRole.modifyingReversedRolesDescription",
    defaultMessage: "Reserved roles are built-in and cannot be removed or modified."
  })))), isDeprecatedRole && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: (0, _model.getExtendedRoleDeprecationNotice)(role),
    color: "warning",
    iconType: "warning"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), getRoleName(), getElasticsearchPrivileges(), getKibanaPrivileges(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), getFormButtons()));
};
exports.EditRolePage = EditRolePage;