"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoleTemplateEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _role_template_type_select = require("./role_template_type_select");
var _role_template_type = require("../services/role_template_type");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RoleTemplateEditor = ({
  roleTemplate,
  onChange,
  onDelete,
  canUseInlineScripts,
  canUseStoredScripts,
  readOnly = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, getTemplateConfigurationFields(), getEditorForTemplate(), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, !readOnly ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "trash",
    color: "danger",
    size: "xs",
    onClick: () => onDelete(roleTemplate),
    "data-test-subj": "deleteRoleTemplateButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRoleMapping.deleteRoleTemplateButton",
    defaultMessage: "Delete template"
  })) : null))));
  function getTemplateFormatSwitch() {
    const returnsJsonLabel = _i18n.i18n.translate('xpack.security.management.editRoleMapping.roleTemplateReturnsJson', {
      defaultMessage: 'Returns JSON'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: returnsJsonLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      "data-test-subj": "roleTemplateFormatSwitch",
      checked: roleTemplate.format === 'json',
      label: returnsJsonLabel,
      showLabel: false,
      onChange: e => {
        onChange({
          ...roleTemplate,
          format: e.target.checked ? 'json' : 'string'
        });
      },
      disabled: readOnly
    }));
  }
  function getTemplateConfigurationFields() {
    const templateTypeComboBox = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.roleTemplateType",
        defaultMessage: "Template type"
      })
    }, /*#__PURE__*/_react.default.createElement(_role_template_type_select.RoleTemplateTypeSelect, {
      roleTemplate: roleTemplate,
      canUseStoredScripts: canUseStoredScripts,
      canUseInlineScripts: canUseInlineScripts,
      onChange: onChange,
      readOnly: readOnly
    })));
    const templateFormatSwitch = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, getTemplateFormatSwitch());
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, templateTypeComboBox, templateFormatSwitch));
  }
  function getEditorForTemplate() {
    if ((0, _role_template_type.isInlineRoleTemplate)(roleTemplate)) {
      const extraProps = {};
      if (!canUseInlineScripts && !readOnly) {
        extraProps.isInvalid = true;
        extraProps.error = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          color: "danger",
          "data-test-subj": "roleMappingInlineScriptsDisabled"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleTemplateInlineScriptsDisabled",
          defaultMessage: "Template uses inline scripts, which are disabled in Elasticsearch."
        }));
      }
      const example = '{{username}}_role';
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 1,
        style: {
          maxWidth: '400px'
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleTemplateLabel",
          defaultMessage: "Template"
        }),
        helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleTemplateHelpText",
          defaultMessage: "Mustache templates are allowed. Example: {example}",
          values: {
            example
          }
        })
      }, extraProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        "data-test-subj": "roleTemplateSourceEditor",
        value: roleTemplate.template.source,
        onChange: e => {
          onChange({
            ...roleTemplate,
            template: {
              source: e.target.value
            }
          });
        },
        disabled: readOnly
      }))));
    }
    if ((0, _role_template_type.isStoredRoleTemplate)(roleTemplate)) {
      const extraProps = {};
      if (!canUseStoredScripts) {
        extraProps.isInvalid = true;
        extraProps.error = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          color: "danger",
          "data-test-subj": "roleMappingStoredScriptsDisabled"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.roleTemplateStoredScriptsDisabled",
          defaultMessage: "Template uses stored scripts, which are disabled in Elasticsearch."
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 1,
        style: {
          maxWidth: '400px'
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.storedScriptLabel",
          defaultMessage: "Stored script ID"
        }),
        helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.storedScriptHelpText",
          defaultMessage: "ID of a previously stored Painless or Mustache script."
        })
      }, extraProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        "data-test-subj": "roleTemplateScriptIdEditor",
        value: roleTemplate.template.id,
        onChange: e => {
          onChange({
            ...roleTemplate,
            template: {
              id: e.target.value
            }
          });
        },
        disabled: readOnly
      }))));
    }
    if ((0, _role_template_type.isInvalidRoleTemplate)(roleTemplate)) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 1,
        "data-test-subj": "roleMappingInvalidRoleTemplate"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "warning",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoleMapping.invalidRoleTemplateTitle",
          defaultMessage: "Invalid role template"
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRoleMapping.invalidRoleTemplateMessage",
        defaultMessage: "Role template is invalid, and cannot be edited here. Please delete and recreate, or fix via the Role Mapping API."
      })));
    }
    throw new Error(`Unable to determine role template type`);
  }
};
exports.RoleTemplateEditor = RoleTemplateEditor;