"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.apiKeysManagementApp = exports.Providers = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _breadcrumb = require("../../components/breadcrumb");
var _use_current_user = require("../../components/use_current_user");
var _readonly_badge = require("../badges/readonly_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const apiKeysManagementApp = Object.freeze({
  id: 'api_keys',
  create({
    authc,
    getStartServices
  }) {
    return {
      id: this.id,
      order: 30,
      title: _i18n.i18n.translate('xpack.security.management.apiKeysTitle', {
        defaultMessage: 'API keys'
      }),
      async mount({
        element,
        theme$,
        setBreadcrumbs,
        history
      }) {
        const [[coreStart], {
          APIKeysGridPage
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./api_keys_grid')))]);
        (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(Providers, {
          services: coreStart,
          theme$: theme$,
          history: history,
          authc: authc,
          onChange: (0, _breadcrumb.createBreadcrumbsChangeHandler)(coreStart.chrome, setBreadcrumbs)
        }, /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
          text: _i18n.i18n.translate('xpack.security.management.apiKeysTitle', {
            defaultMessage: 'API keys'
          }),
          href: "/"
        }, /*#__PURE__*/_react.default.createElement(APIKeysGridPage, null))), element);
        return () => {
          (0, _reactDom.unmountComponentAtNode)(element);
        };
      }
    };
  }
});
exports.apiKeysManagementApp = apiKeysManagementApp;
const Providers = ({
  services,
  theme$,
  history,
  authc,
  onChange,
  children
}) => /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
  services: services
}, /*#__PURE__*/_react.default.createElement(_use_current_user.AuthenticationProvider, {
  authc: authc
}, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
  theme$: theme$
}, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
  history: history
}, /*#__PURE__*/_react.default.createElement(_readonly_badge.ReadonlyBadge, {
  featureId: "api_keys",
  tooltip: _i18n.i18n.translate('xpack.security.management.api_keys.readonlyTooltip', {
    defaultMessage: 'Unable to create or edit API keys'
  })
}), /*#__PURE__*/_react.default.createElement(_breadcrumb.BreadcrumbsProvider, {
  onChange: onChange
}, children))))));
exports.Providers = Providers;