"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyFlyout = void 0;
exports.mapCreateApiKeyValues = mapCreateApiKeyValues;
exports.mapUpdateApiKeyValues = mapUpdateApiKeyValues;
var _eui = require("@elastic/eui");
var _formik = require("formik");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _react = _interopRequireWildcard(require("react"));
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _api_keys_grid_page = require("./api_keys_grid_page");
var _doc_link = require("../../../components/doc_link");
var _form_field = require("../../../components/form_field");
var _form_row = require("../../../components/form_row");
var _use_current_user = require("../../../components/use_current_user");
var _use_html_id = require("../../../components/use_html_id");
var _use_initial_focus = require("../../../components/use_initial_focus");
var _roles_api_client = require("../../roles/roles_api_client");
var _api_keys_api_client = require("../api_keys_api_client");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultInitialValues = {
  name: '',
  type: 'rest',
  customExpiration: false,
  expiration: '',
  includeMetadata: false,
  metadata: '{}',
  customPrivileges: false,
  access: JSON.stringify({
    search: [{
      names: ['*']
    }],
    replication: [{
      names: ['*']
    }]
  }, null, 2),
  role_descriptors: '{}'
};
const ApiKeyFlyout = ({
  onSuccess,
  onCancel,
  apiKey,
  canManageCrossClusterApiKeys = false,
  readOnly = false
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const {
    value: currentUser,
    loading: isLoadingCurrentUser
  } = (0, _use_current_user.useCurrentUser)();
  const [{
    value: roles,
    loading: isLoadingRoles
  }, getRoles] = (0, _useAsyncFn.default)(() => new _roles_api_client.RolesAPIClient(services.http).getRoles(), [services.http]);
  const formik = (0, _formik.useFormik)({
    onSubmit: async values => {
      try {
        if (apiKey) {
          const updateApiKeyResponse = await new _api_keys_api_client.APIKeysAPIClient(services.http).updateApiKey(mapUpdateApiKeyValues(apiKey.type, apiKey.id, values));
          onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess(updateApiKeyResponse);
        } else {
          const createApiKeyResponse = await new _api_keys_api_client.APIKeysAPIClient(services.http).createApiKey(mapCreateApiKeyValues(values));
          onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess(createApiKeyResponse);
        }
      } catch (error) {
        throw error;
      }
    },
    initialValues: apiKey ? mapApiKeyFormValues(apiKey) : defaultInitialValues
  });
  (0, _react.useEffect)(() => {
    getRoles();
  }, []); // eslint-disable-line react-hooks/exhaustive-deps

  (0, _react.useEffect)(() => {
    if (currentUser && roles) {
      const userPermissions = currentUser.roles.reduce((accumulator, roleName) => {
        const role = roles.find(r => r.name === roleName);
        if (role) {
          accumulator[role.name] = role.elasticsearch;
        }
        return accumulator;
      }, {});
      if (!formik.touched.role_descriptors && !apiKey) {
        formik.setFieldValue('role_descriptors', JSON.stringify(userPermissions, null, 2));
      }
    }
  }, [currentUser, roles]); // eslint-disable-line react-hooks/exhaustive-deps

  const isLoading = isLoadingCurrentUser || isLoadingRoles;
  const isOwner = currentUser && apiKey ? currentUser.username === apiKey.username : false;
  const hasExpired = apiKey ? apiKey.expiration && (0, _momentTimezone.default)(apiKey.expiration).isBefore() : false;
  const canEdit = isOwner && !hasExpired;
  const firstFieldRef = (0, _use_initial_focus.useInitialFocus)([isLoading]);
  const titleId = (0, _use_html_id.useHtmlId)('formFlyout', 'title');
  const isSubmitButtonHidden = readOnly || apiKey && !canEdit;
  const isSubmitDisabled = isLoading || formik.submitCount > 0 && !formik.isValid || readOnly || apiKey && !canEdit;
  const title = apiKey ? readOnly || !canEdit ? _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.viewTitle', {
    defaultMessage: `API key details`
  }) : _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.updateTitle', {
    defaultMessage: `Update API key`
  }) : _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.createTitle', {
    defaultMessage: `Create API key`
  });
  const submitButtonText = apiKey ? _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.updateSubmitButton', {
    defaultMessage: `{isSubmitting, select, true{Updating API key…} other{Update API key}}`,
    values: {
      isSubmitting: formik.isSubmitting
    }
  }) : _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.createSubmitButton', {
    defaultMessage: `{isSubmitting, select, true{Creating API key…} other{Create API key}}`,
    values: {
      isSubmitting: formik.isSubmitting
    }
  });
  return /*#__PURE__*/_react.default.createElement(_formik.FormikProvider, {
    value: formik
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onCancel,
    "aria-labelledby": titleId,
    size: "m",
    ownFocus: true
  }, /*#__PURE__*/_react.default.createElement(_formik.Form, {
    onSubmit: formik.handleSubmit,
    style: {
      display: 'flex',
      flexDirection: 'column',
      height: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: titleId
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    isLoading: isLoading
  }, apiKey && !readOnly ? !isOwner ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "lock",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.readonlyOwnedByOtherUserWarning",
      defaultMessage: "You cannot update this API key, since it is owned by another user."
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : hasExpired ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "lock",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.readonlyExpiredWarning",
      defaultMessage: "You cannot update this API key, since it has already expired."
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null : null, /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.nameLabel",
      defaultMessage: "Name"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_form_field.FormField, {
    name: "name",
    inputRef: firstFieldRef,
    "data-test-subj": "apiKeyNameInput",
    disabled: readOnly || !!apiKey,
    validate: {
      required: _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.nameRequired', {
        defaultMessage: 'Enter a name.'
      })
    },
    fullWidth: true
  })), apiKey ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.typeLabel",
      defaultMessage: "Type"
    })
  }, /*#__PURE__*/_react.default.createElement(_api_keys_grid_page.ApiKeyBadge, {
    type: apiKey.type
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.ownerLabel",
      defaultMessage: "Owner"
    })
  }, /*#__PURE__*/_react.default.createElement(_api_keys_grid_page.UsernameWithIcon, {
    username: apiKey.username
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.createdLabel",
      defaultMessage: "Created"
    })
  }, /*#__PURE__*/_react.default.createElement(_api_keys_grid_page.TimeToolTip, {
    timestamp: apiKey.creation
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.statusLabel",
      defaultMessage: "Status"
    })
  }, /*#__PURE__*/_react.default.createElement(_api_keys_grid_page.ApiKeyStatus, {
    expiration: apiKey.expiration
  }))))) : canManageCrossClusterApiKeys ? /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    name: "type",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.typeLabel",
      defaultMessage: "Type"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: "rest",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.restTypeLabel",
      defaultMessage: "Personal API key"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.restTypeDescription",
      defaultMessage: "Allow external services to access the Elastic Stack on your behalf."
    }))),
    onChange: () => formik.setFieldValue('type', 'rest'),
    checked: formik.values.type === 'rest'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: "cross_cluster",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.crossClusterTypeLabel",
      defaultMessage: "Cross-Cluster API key"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.crossClusterTypeDescription",
      defaultMessage: "Allow remote clusters to connect to your local cluster."
    }))),
    onChange: () => formik.setFieldValue('type', 'cross_cluster'),
    checked: formik.values.type === 'cross_cluster'
  })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.typeLabel",
      defaultMessage: "Type"
    })
  }, /*#__PURE__*/_react.default.createElement(_api_keys_grid_page.ApiKeyBadge, {
    type: "rest"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), formik.values.type === 'cross_cluster' ? /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    "data-test-subj": "apiKeysAccessCodeEditor",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.accessLabel",
      defaultMessage: "Access"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
      app: "elasticsearch",
      doc: "security-api-create-cross-cluster-api-key.html#security-api-create-cross-cluster-api-key-request-body"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.accessHelpText",
      defaultMessage: "Learn how to structure access permissions."
    })),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_form_field.FormField, {
    as: _public.CodeEditorField,
    name: "access",
    "aria-label": _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.accessCodeEditor', {
      defaultMessage: 'Code editor for access permissions'
    }),
    value: formik.values.access,
    options: {
      readOnly: readOnly || apiKey && !canEdit
    },
    onChange: value => formik.setFieldValue('access', value),
    validate: value => {
      if (!value) {
        return _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.accessRequired', {
          defaultMessage: 'Enter access permissions or disable this option.'
        });
      }
      try {
        JSON.parse(value);
      } catch (e) {
        return _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.invalidJsonError', {
          defaultMessage: 'Enter valid JSON.'
        });
      }
    },
    fullWidth: true,
    languageId: "xjson",
    height: 200
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.customPrivilegesLabel",
      defaultMessage: "Restrict privileges"
    }),
    checked: formik.values.customPrivileges,
    "data-test-subj": "apiKeysRoleDescriptorsSwitch",
    onChange: e => formik.setFieldValue('customPrivileges', e.target.checked),
    disabled: readOnly || apiKey && !canEdit
  }), formik.values.customPrivileges && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    helpText: /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
      app: "elasticsearch",
      doc: "security-api-create-api-key.html#security-api-create-api-key-request-body"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.roleDescriptorsHelpText",
      defaultMessage: "Learn how to structure role descriptors."
    })),
    fullWidth: true,
    "data-test-subj": "apiKeysRoleDescriptorsCodeEditor"
  }, /*#__PURE__*/_react.default.createElement(_form_field.FormField, {
    as: _public.CodeEditorField,
    name: "role_descriptors",
    "aria-label": _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.roleDescriptorsCodeEditor', {
      defaultMessage: 'Code editor for role descriptors of this API key'
    }),
    value: formik.values.role_descriptors,
    options: {
      readOnly: readOnly || apiKey && !canEdit
    },
    onChange: value => formik.setFieldValue('role_descriptors', value),
    validate: value => {
      if (!value) {
        return _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.roleDescriptorsRequired', {
          defaultMessage: 'Enter role descriptors or disable this option.'
        });
      }
      try {
        JSON.parse(value);
      } catch (e) {
        return _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.invalidJsonError', {
          defaultMessage: 'Enter valid JSON.'
        });
      }
    },
    fullWidth: true,
    languageId: "xjson",
    height: 200
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))), !apiKey && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.customExpirationLabel",
      defaultMessage: "Expire after time"
    }),
    checked: formik.values.customExpiration,
    onChange: e => formik.setFieldValue('customExpiration', e.target.checked),
    disabled: readOnly || !!apiKey,
    "data-test-subj": "apiKeyCustomExpirationSwitch"
  }), formik.values.customExpiration && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.customExpirationInputLabel",
      defaultMessage: "Lifetime"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_form_field.FormField, {
    as: _eui.EuiFieldNumber,
    name: "expiration",
    min: 0,
    append: _i18n.i18n.translate('xpack.security.accountManagement.apiKeyFlyout.expirationUnit', {
      defaultMessage: 'days'
    }),
    validate: {
      min: {
        value: 1,
        message: _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.expirationRequired', {
          defaultMessage: 'Enter a valid duration or disable this option.'
        })
      }
    },
    disabled: readOnly || !!apiKey,
    "data-test-subj": "apiKeyCustomExpirationInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.includeMetadataLabel",
      defaultMessage: "Include metadata"
    }),
    "data-test-subj": "apiKeysMetadataSwitch",
    checked: formik.values.includeMetadata,
    disabled: readOnly || apiKey && !canEdit,
    onChange: e => formik.setFieldValue('includeMetadata', e.target.checked)
  }), formik.values.includeMetadata && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
    "data-test-subj": "apiKeysMetadataCodeEditor",
    helpText: /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
      app: "elasticsearch",
      doc: "security-api-create-api-key.html#security-api-create-api-key-request-body"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeyFlyout.metadataHelpText",
      defaultMessage: "Learn how to structure metadata."
    })),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_form_field.FormField, {
    as: _public.CodeEditorField,
    name: "metadata",
    "aria-label": _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.metadataCodeEditor', {
      defaultMessage: 'Code editor for arbitrary metadata associated with the API key'
    }),
    options: {
      readOnly: readOnly || apiKey && !canEdit
    },
    value: formik.values.metadata,
    onChange: value => formik.setFieldValue('metadata', value),
    validate: value => {
      if (!value) {
        return _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.metadataRequired', {
          defaultMessage: 'Enter metadata or disable this option.'
        });
      }
      try {
        JSON.parse(value);
      } catch (e) {
        return _i18n.i18n.translate('xpack.security.management.apiKeys.apiKeyFlyout.invalidJsonError', {
          defaultMessage: 'Enter valid JSON.'
        });
      }
    },
    fullWidth: true,
    languageId: "xjson",
    height: 200
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "formFlyoutCancelButton",
    flush: "right",
    isDisabled: isLoading,
    onClick: onCancel
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.formFlyout.cancelButton",
    defaultMessage: "Cancel"
  }))), !isSubmitButtonHidden && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "formFlyoutSubmitButton",
    isLoading: formik.isSubmitting,
    isDisabled: isSubmitDisabled,
    fill: true,
    type: "submit"
  }, submitButtonText)))))));
};
exports.ApiKeyFlyout = ApiKeyFlyout;
function mapCreateApiKeyValues(values) {
  const {
    type,
    name
  } = values;
  const expiration = values.customExpiration ? `${values.expiration}d` : undefined;
  const metadata = values.includeMetadata ? JSON.parse(values.metadata) : '{}';
  if (type === 'cross_cluster') {
    return {
      type,
      name,
      expiration,
      metadata,
      access: JSON.parse(values.access)
    };
  }
  return {
    name,
    expiration,
    metadata,
    role_descriptors: values.customPrivileges ? JSON.parse(values.role_descriptors) : '{}'
  };
}
function mapUpdateApiKeyValues(type, id, values) {
  const metadata = values.includeMetadata ? JSON.parse(values.metadata) : '{}';
  if (type === 'cross_cluster') {
    return {
      type,
      id,
      metadata,
      access: JSON.parse(values.access)
    };
  }
  return {
    id,
    metadata,
    role_descriptors: values.customPrivileges ? JSON.parse(values.role_descriptors) : '{}'
  };
}

/**
 * Maps data from the selected API key to pre-populate the form
 */
function mapApiKeyFormValues(apiKey) {
  const includeMetadata = Object.keys(apiKey.metadata).length > 0;
  const customPrivileges = apiKey.type !== 'cross_cluster' ? Object.keys(apiKey.role_descriptors).length > 0 : false;
  return {
    name: apiKey.name,
    type: apiKey.type,
    customExpiration: !!apiKey.expiration,
    expiration: !!apiKey.expiration ? apiKey.expiration.toString() : '',
    includeMetadata,
    metadata: includeMetadata ? JSON.stringify(apiKey.metadata, null, 2) : '{}',
    customPrivileges,
    role_descriptors: customPrivileges ? JSON.stringify(apiKey.type !== 'cross_cluster' && apiKey.role_descriptors, null, 2) : '{}',
    access: apiKey.type === 'cross_cluster' ? JSON.stringify(apiKey.access, null, 2) : '{}'
  };
}